import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudNetworkingNetworkV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html#matching_subnet_cidr DataOpentelekomcloudNetworkingNetworkV2#matching_subnet_cidr}.
     *
     * @stability stable
     */
    readonly matchingSubnetCidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html#name DataOpentelekomcloudNetworkingNetworkV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html#network_id DataOpentelekomcloudNetworkingNetworkV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html#region DataOpentelekomcloudNetworkingNetworkV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The ID of the Tenant (Identity v2) or Project (Identity v3) to login with.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html#tenant_id DataOpentelekomcloudNetworkingNetworkV2#tenant_id}
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html opentelekomcloud_networking_network_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudNetworkingNetworkV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_network_v2.html opentelekomcloud_networking_network_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudNetworkingNetworkV2Config);
    /**
     * @stability stable
     */
    get adminStateUp(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _matchingSubnetCidr?;
    /**
     * @stability stable
     */
    get matchingSubnetCidr(): string | undefined;
    /**
     * @stability stable
     */
    set matchingSubnetCidr(value: string | undefined);
    /**
     * @stability stable
     */
    resetMatchingSubnetCidr(): void;
    /**
     * @stability stable
     */
    get matchingSubnetCidrInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string | undefined;
    /**
     * @stability stable
     */
    set networkId(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkId(): void;
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get shared(): string;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
