import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudNetworkingPortV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#admin_state_up DataOpentelekomcloudNetworkingPortV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#device_id DataOpentelekomcloudNetworkingPortV2#device_id}.
     *
     * @stability stable
     */
    readonly deviceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#device_owner DataOpentelekomcloudNetworkingPortV2#device_owner}.
     *
     * @stability stable
     */
    readonly deviceOwner?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#fixed_ip DataOpentelekomcloudNetworkingPortV2#fixed_ip}.
     *
     * @stability stable
     */
    readonly fixedIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#mac_address DataOpentelekomcloudNetworkingPortV2#mac_address}.
     *
     * @stability stable
     */
    readonly macAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#name DataOpentelekomcloudNetworkingPortV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#network_id DataOpentelekomcloudNetworkingPortV2#network_id}.
     *
     * @stability stable
     */
    readonly networkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#port_id DataOpentelekomcloudNetworkingPortV2#port_id}.
     *
     * @stability stable
     */
    readonly portId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#project_id DataOpentelekomcloudNetworkingPortV2#project_id}.
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#region DataOpentelekomcloudNetworkingPortV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#security_group_ids DataOpentelekomcloudNetworkingPortV2#security_group_ids}.
     *
     * @stability stable
     */
    readonly securityGroupIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#status DataOpentelekomcloudNetworkingPortV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html#tenant_id DataOpentelekomcloudNetworkingPortV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html opentelekomcloud_networking_port_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudNetworkingPortV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_port_v2.html opentelekomcloud_networking_port_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudNetworkingPortV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get allFixedIps(): string[];
    /**
     * @stability stable
     */
    get allSecurityGroupIds(): string[];
    private _deviceId?;
    /**
     * @stability stable
     */
    get deviceId(): string | undefined;
    /**
     * @stability stable
     */
    set deviceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceId(): void;
    /**
     * @stability stable
     */
    get deviceIdInput(): string | undefined;
    private _deviceOwner?;
    /**
     * @stability stable
     */
    get deviceOwner(): string | undefined;
    /**
     * @stability stable
     */
    set deviceOwner(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceOwner(): void;
    /**
     * @stability stable
     */
    get deviceOwnerInput(): string | undefined;
    private _fixedIp?;
    /**
     * @stability stable
     */
    get fixedIp(): string | undefined;
    /**
     * @stability stable
     */
    set fixedIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetFixedIp(): void;
    /**
     * @stability stable
     */
    get fixedIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _macAddress?;
    /**
     * @stability stable
     */
    get macAddress(): string | undefined;
    /**
     * @stability stable
     */
    set macAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetMacAddress(): void;
    /**
     * @stability stable
     */
    get macAddressInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkId?;
    /**
     * @stability stable
     */
    get networkId(): string | undefined;
    /**
     * @stability stable
     */
    set networkId(value: string | undefined);
    /**
     * @stability stable
     */
    resetNetworkId(): void;
    /**
     * @stability stable
     */
    get networkIdInput(): string | undefined;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string | undefined;
    /**
     * @stability stable
     */
    set portId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortId(): void;
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroupIds?;
    /**
     * @stability stable
     */
    get securityGroupIds(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroupIds(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroupIds(): void;
    /**
     * @stability stable
     */
    get securityGroupIdsInput(): string[] | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
