import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudNetworkingSecgroupV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html#name DataOpentelekomcloudNetworkingSecgroupV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html#region DataOpentelekomcloudNetworkingSecgroupV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html#secgroup_id DataOpentelekomcloudNetworkingSecgroupV2#secgroup_id}.
     *
     * @stability stable
     */
    readonly secgroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html#tenant_id DataOpentelekomcloudNetworkingSecgroupV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html opentelekomcloud_networking_secgroup_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudNetworkingSecgroupV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/networking_secgroup_v2.html opentelekomcloud_networking_secgroup_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudNetworkingSecgroupV2Config);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _secgroupId?;
    /**
     * @stability stable
     */
    get secgroupId(): string | undefined;
    /**
     * @stability stable
     */
    set secgroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecgroupId(): void;
    /**
     * @stability stable
     */
    get secgroupIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
