import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudObsBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket_object.html#bucket DataOpentelekomcloudObsBucketObject#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket_object.html#key DataOpentelekomcloudObsBucketObject#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket_object.html#version_id DataOpentelekomcloudObsBucketObject#version_id}.
     *
     * @stability stable
     */
    readonly versionId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket_object.html opentelekomcloud_obs_bucket_object}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketObject extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket_object.html opentelekomcloud_obs_bucket_object} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudObsBucketObjectConfig);
    /**
     * @stability stable
     */
    get body(): string;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    get contentLanguage(): string;
    /**
     * @stability stable
     */
    get contentLength(): number;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    get expires(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    /**
     * @stability stable
     */
    get lastModified(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string | undefined;
    /**
     * @stability stable
     */
    set versionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersionId(): void;
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get websiteRedirectLocation(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
