import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudObsBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket.html#bucket DataOpentelekomcloudObsBucket#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketCorsRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedHeaders(): string[];
    /**
     * @stability stable
     */
    get allowedMethods(): string[];
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    get exposeHeaders(): string[];
    /**
     * @stability stable
     */
    get maxAgeSeconds(): number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketEventNotificationsFilterRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketEventNotifications extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get events(): string[];
    /**
     * @stability stable
     */
    get filterRule(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get topic(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLifecycleRuleExpiration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get days(): number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionExpiration extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get days(): number;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLifecycleRuleNoncurrentVersionTransition extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    get storageClass(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLifecycleRuleTransition extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    get storageClass(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLifecycleRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get expiration(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get noncurrentVersionExpiration(): any;
    /**
     * @stability stable
     */
    get noncurrentVersionTransition(): any;
    /**
     * @stability stable
     */
    get prefix(): string;
    /**
     * @stability stable
     */
    get transition(): any;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketLogging extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get targetBucket(): string;
    /**
     * @stability stable
     */
    get targetPrefix(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketServerSideEncryption extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get algorithm(): string;
    /**
     * @stability stable
     */
    get kmsKeyId(): string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucketWebsite extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get errorDocument(): string;
    /**
     * @stability stable
     */
    get indexDocument(): string;
    /**
     * @stability stable
     */
    get redirectAllRequestsTo(): string;
    /**
     * @stability stable
     */
    get routingRules(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket.html opentelekomcloud_obs_bucket}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudObsBucket extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/obs_bucket.html opentelekomcloud_obs_bucket} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudObsBucketConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get bucketDomainName(): string;
    /**
     * @stability stable
     */
    corsRule(index: string): DataOpentelekomcloudObsBucketCorsRule;
    /**
     * @stability stable
     */
    eventNotifications(index: string): DataOpentelekomcloudObsBucketEventNotifications;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    lifecycleRule(index: string): DataOpentelekomcloudObsBucketLifecycleRule;
    /**
     * @stability stable
     */
    logging(index: string): DataOpentelekomcloudObsBucketLogging;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    serverSideEncryption(index: string): DataOpentelekomcloudObsBucketServerSideEncryption;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get versioning(): any;
    /**
     * @stability stable
     */
    website(index: string): DataOpentelekomcloudObsBucketWebsite;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
