import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudRdsFlavorsV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html#datastore_name DataOpentelekomcloudRdsFlavorsV1#datastore_name}.
     *
     * @stability stable
     */
    readonly datastoreName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html#datastore_version DataOpentelekomcloudRdsFlavorsV1#datastore_version}.
     *
     * @stability stable
     */
    readonly datastoreVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html#region DataOpentelekomcloudRdsFlavorsV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html#speccode DataOpentelekomcloudRdsFlavorsV1#speccode}.
     *
     * @stability stable
     */
    readonly speccode?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html opentelekomcloud_rds_flavors_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudRdsFlavorsV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v1.html opentelekomcloud_rds_flavors_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudRdsFlavorsV1Config);
    private _datastoreName?;
    /**
     * @stability stable
     */
    get datastoreName(): string;
    /**
     * @stability stable
     */
    set datastoreName(value: string);
    /**
     * @stability stable
     */
    get datastoreNameInput(): string | undefined;
    private _datastoreVersion?;
    /**
     * @stability stable
     */
    get datastoreVersion(): string;
    /**
     * @stability stable
     */
    set datastoreVersion(value: string);
    /**
     * @stability stable
     */
    get datastoreVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get ram(): number;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _speccode?;
    /**
     * @stability stable
     */
    get speccode(): string | undefined;
    /**
     * @stability stable
     */
    set speccode(value: string | undefined);
    /**
     * @stability stable
     */
    resetSpeccode(): void;
    /**
     * @stability stable
     */
    get speccodeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
