import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudRdsFlavorsV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3.html#db_type DataOpentelekomcloudRdsFlavorsV3#db_type}.
     *
     * @stability stable
     */
    readonly dbType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3.html#db_version DataOpentelekomcloudRdsFlavorsV3#db_version}.
     *
     * @stability stable
     */
    readonly dbVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3.html#instance_mode DataOpentelekomcloudRdsFlavorsV3#instance_mode}.
     *
     * @stability stable
     */
    readonly instanceMode: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudRdsFlavorsV3Flavors extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get azStatus(): any;
    /**
     * @stability stable
     */
    get memory(): number;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get vcpus(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3.html opentelekomcloud_rds_flavors_v3}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudRdsFlavorsV3 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rds_flavors_v3.html opentelekomcloud_rds_flavors_v3} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudRdsFlavorsV3Config);
    private _dbType?;
    /**
     * @stability stable
     */
    get dbType(): string;
    /**
     * @stability stable
     */
    set dbType(value: string);
    /**
     * @stability stable
     */
    get dbTypeInput(): string | undefined;
    private _dbVersion?;
    /**
     * @stability stable
     */
    get dbVersion(): string;
    /**
     * @stability stable
     */
    set dbVersion(value: string);
    /**
     * @stability stable
     */
    get dbVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    flavors(index: string): DataOpentelekomcloudRdsFlavorsV3Flavors;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceMode?;
    /**
     * @stability stable
     */
    get instanceMode(): string;
    /**
     * @stability stable
     */
    set instanceMode(value: string);
    /**
     * @stability stable
     */
    get instanceModeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
