import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudRtsStackResourceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html#physical_resource_id DataOpentelekomcloudRtsStackResourceV1#physical_resource_id}.
     *
     * @stability stable
     */
    readonly physicalResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html#region DataOpentelekomcloudRtsStackResourceV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html#resource_name DataOpentelekomcloudRtsStackResourceV1#resource_name}.
     *
     * @stability stable
     */
    readonly resourceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html#resource_type DataOpentelekomcloudRtsStackResourceV1#resource_type}.
     *
     * @stability stable
     */
    readonly resourceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html#stack_name DataOpentelekomcloudRtsStackResourceV1#stack_name}.
     *
     * @stability stable
     */
    readonly stackName: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html opentelekomcloud_rts_stack_resource_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudRtsStackResourceV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_resource_v1.html opentelekomcloud_rts_stack_resource_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudRtsStackResourceV1Config);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get logicalResourceId(): string;
    private _physicalResourceId?;
    /**
     * @stability stable
     */
    get physicalResourceId(): string | undefined;
    /**
     * @stability stable
     */
    set physicalResourceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPhysicalResourceId(): void;
    /**
     * @stability stable
     */
    get physicalResourceIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get requiredBy(): string[];
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceStatus(): string;
    /**
     * @stability stable
     */
    get resourceStatusReason(): string;
    private _resourceType?;
    /**
     * @stability stable
     */
    get resourceType(): string | undefined;
    /**
     * @stability stable
     */
    set resourceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceType(): void;
    /**
     * @stability stable
     */
    get resourceTypeInput(): string | undefined;
    private _stackName?;
    /**
     * @stability stable
     */
    get stackName(): string;
    /**
     * @stability stable
     */
    set stackName(value: string);
    /**
     * @stability stable
     */
    get stackNameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
