import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudRtsStackV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_v1.html#name DataOpentelekomcloudRtsStackV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_v1.html#region DataOpentelekomcloudRtsStackV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_v1.html opentelekomcloud_rts_stack_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudRtsStackV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/rts_stack_v1.html opentelekomcloud_rts_stack_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudRtsStackV1Config);
    /**
     * @stability stable
     */
    get capabilities(): string[];
    /**
     * @stability stable
     */
    get disableRollback(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get notificationTopics(): string[];
    /**
     * @stability stable
     */
    outputs(key: string): string;
    /**
     * @stability stable
     */
    parameters(key: string): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get statusReason(): string;
    /**
     * @stability stable
     */
    get templateBody(): string;
    /**
     * @stability stable
     */
    get timeoutMins(): number;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
