import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudS3BucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html#bucket DataOpentelekomcloudS3BucketObject#bucket}.
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html#key DataOpentelekomcloudS3BucketObject#key}.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html#range DataOpentelekomcloudS3BucketObject#range}.
     *
     * @stability stable
     */
    readonly range?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html#version_id DataOpentelekomcloudS3BucketObject#version_id}.
     *
     * @stability stable
     */
    readonly versionId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html opentelekomcloud_s3_bucket_object}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudS3BucketObject extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/s3_bucket_object.html opentelekomcloud_s3_bucket_object} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudS3BucketObjectConfig);
    /**
     * @stability stable
     */
    get body(): string;
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    get contentLanguage(): string;
    /**
     * @stability stable
     */
    get contentLength(): number;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    get expires(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    set key(value: string);
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    /**
     * @stability stable
     */
    get lastModified(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _range?;
    /**
     * @stability stable
     */
    get range(): string | undefined;
    /**
     * @stability stable
     */
    set range(value: string | undefined);
    /**
     * @stability stable
     */
    resetRange(): void;
    /**
     * @stability stable
     */
    get rangeInput(): string | undefined;
    /**
     * @stability stable
     */
    get serverSideEncryption(): string;
    /**
     * @stability stable
     */
    get sseKmsKeyId(): string;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string | undefined;
    /**
     * @stability stable
     */
    set versionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVersionId(): void;
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get websiteRedirectLocation(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
