import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudSfsFileSystemV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html#id DataOpentelekomcloudSfsFileSystemV2#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html#name DataOpentelekomcloudSfsFileSystemV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html#region DataOpentelekomcloudSfsFileSystemV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html#status DataOpentelekomcloudSfsFileSystemV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html opentelekomcloud_sfs_file_system_v2}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudSfsFileSystemV2 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/sfs_file_system_v2.html opentelekomcloud_sfs_file_system_v2} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudSfsFileSystemV2Config);
    /**
     * @stability stable
     */
    get accessLevel(): string;
    /**
     * @stability stable
     */
    get accessTo(): string;
    /**
     * @stability stable
     */
    get accessType(): string;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get exportLocation(): string;
    /**
     * @stability stable
     */
    get exportLocations(): string[];
    /**
     * @stability stable
     */
    get host(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get isPublic(): any;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    /**
     * @stability stable
     */
    get mountId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get preferred(): any;
    /**
     * @stability stable
     */
    get projectId(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get shareAccessId(): string;
    /**
     * @stability stable
     */
    get shareInstanceId(): string;
    /**
     * @stability stable
     */
    get shareProto(): string;
    /**
     * @stability stable
     */
    get shareType(): string;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    get state(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get volumeType(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
