import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudVpcBandwidthConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html#enterprise_project_id DataOpentelekomcloudVpcBandwidth#enterprise_project_id}.
     *
     * @stability stable
     */
    readonly enterpriseProjectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html#name DataOpentelekomcloudVpcBandwidth#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html#region DataOpentelekomcloudVpcBandwidth#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html#size DataOpentelekomcloudVpcBandwidth#size}.
     *
     * @stability stable
     */
    readonly size?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html opentelekomcloud_vpc_bandwidth}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcBandwidth extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_bandwidth.html opentelekomcloud_vpc_bandwidth} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataOpentelekomcloudVpcBandwidthConfig);
    /**
     * @stability stable
     */
    get bandwidthType(): string;
    /**
     * @stability stable
     */
    get chargeMode(): string;
    private _enterpriseProjectId?;
    /**
     * @stability stable
     */
    get enterpriseProjectId(): string | undefined;
    /**
     * @stability stable
     */
    set enterpriseProjectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetEnterpriseProjectId(): void;
    /**
     * @stability stable
     */
    get enterpriseProjectIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get shareType(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number | undefined;
    /**
     * @stability stable
     */
    set size(value: number | undefined);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
