import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudVpcEipV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#bandwidth_id DataOpentelekomcloudVpcEipV1#bandwidth_id}.
     *
     * @stability stable
     */
    readonly bandwidthId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#id DataOpentelekomcloudVpcEipV1#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#port_id DataOpentelekomcloudVpcEipV1#port_id}.
     *
     * @stability stable
     */
    readonly portId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#private_ip_address DataOpentelekomcloudVpcEipV1#private_ip_address}.
     *
     * @stability stable
     */
    readonly privateIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#public_ip_address DataOpentelekomcloudVpcEipV1#public_ip_address}.
     *
     * @stability stable
     */
    readonly publicIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#region DataOpentelekomcloudVpcEipV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#status DataOpentelekomcloudVpcEipV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html#tags DataOpentelekomcloudVpcEipV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html opentelekomcloud_vpc_eip_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcEipV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_eip_v1.html opentelekomcloud_vpc_eip_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcEipV1Config);
    private _bandwidthId?;
    /**
     * @stability stable
     */
    get bandwidthId(): string | undefined;
    /**
     * @stability stable
     */
    set bandwidthId(value: string | undefined);
    /**
     * @stability stable
     */
    resetBandwidthId(): void;
    /**
     * @stability stable
     */
    get bandwidthIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get bandwidthShareType(): string;
    /**
     * @stability stable
     */
    get bandwidthSize(): number;
    /**
     * @stability stable
     */
    get createTime(): string;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    /**
     * @stability stable
     */
    get ipVersion(): number;
    private _portId?;
    /**
     * @stability stable
     */
    get portId(): string | undefined;
    /**
     * @stability stable
     */
    set portId(value: string | undefined);
    /**
     * @stability stable
     */
    resetPortId(): void;
    /**
     * @stability stable
     */
    get portIdInput(): string | undefined;
    private _privateIpAddress?;
    /**
     * @stability stable
     */
    get privateIpAddress(): string | undefined;
    /**
     * @stability stable
     */
    set privateIpAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateIpAddress(): void;
    /**
     * @stability stable
     */
    get privateIpAddressInput(): string | undefined;
    private _publicIpAddress?;
    /**
     * @stability stable
     */
    get publicIpAddress(): string | undefined;
    /**
     * @stability stable
     */
    set publicIpAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetPublicIpAddress(): void;
    /**
     * @stability stable
     */
    get publicIpAddressInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
