import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudVpcSubnetV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#availability_zone DataOpentelekomcloudVpcSubnetV1#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#cidr DataOpentelekomcloudVpcSubnetV1#cidr}.
     *
     * @stability stable
     */
    readonly cidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#gateway_ip DataOpentelekomcloudVpcSubnetV1#gateway_ip}.
     *
     * @stability stable
     */
    readonly gatewayIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#name DataOpentelekomcloudVpcSubnetV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#primary_dns DataOpentelekomcloudVpcSubnetV1#primary_dns}.
     *
     * @stability stable
     */
    readonly primaryDns?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#region DataOpentelekomcloudVpcSubnetV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#secondary_dns DataOpentelekomcloudVpcSubnetV1#secondary_dns}.
     *
     * @stability stable
     */
    readonly secondaryDns?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#status DataOpentelekomcloudVpcSubnetV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html#vpc_id DataOpentelekomcloudVpcSubnetV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html opentelekomcloud_vpc_subnet_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcSubnetV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_subnet_v1.html opentelekomcloud_vpc_subnet_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcSubnetV1Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string | undefined;
    /**
     * @stability stable
     */
    set availabilityZone(value: string | undefined);
    /**
     * @stability stable
     */
    resetAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _cidr?;
    /**
     * @stability stable
     */
    get cidr(): string | undefined;
    /**
     * @stability stable
     */
    set cidr(value: string | undefined);
    /**
     * @stability stable
     */
    resetCidr(): void;
    /**
     * @stability stable
     */
    get cidrInput(): string | undefined;
    /**
     * @stability stable
     */
    get dhcpEnable(): any;
    /**
     * @stability stable
     */
    get dnsList(): string[];
    private _gatewayIp?;
    /**
     * @stability stable
     */
    get gatewayIp(): string | undefined;
    /**
     * @stability stable
     */
    set gatewayIp(value: string | undefined);
    /**
     * @stability stable
     */
    resetGatewayIp(): void;
    /**
     * @stability stable
     */
    get gatewayIpInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get networkId(): string;
    private _primaryDns?;
    /**
     * @stability stable
     */
    get primaryDns(): string | undefined;
    /**
     * @stability stable
     */
    set primaryDns(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrimaryDns(): void;
    /**
     * @stability stable
     */
    get primaryDnsInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _secondaryDns?;
    /**
     * @stability stable
     */
    get secondaryDns(): string | undefined;
    /**
     * @stability stable
     */
    set secondaryDns(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecondaryDns(): void;
    /**
     * @stability stable
     */
    get secondaryDnsInput(): string | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetId(): string;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string | undefined;
    /**
     * @stability stable
     */
    set vpcId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVpcId(): void;
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
