import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudVpcV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#cidr DataOpentelekomcloudVpcV1#cidr}.
     *
     * @stability stable
     */
    readonly cidr?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#id DataOpentelekomcloudVpcV1#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#name DataOpentelekomcloudVpcV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#region DataOpentelekomcloudVpcV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#shared DataOpentelekomcloudVpcV1#shared}.
     *
     * @stability stable
     */
    readonly shared?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html#status DataOpentelekomcloudVpcV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcV1Routes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    get nexthop(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html opentelekomcloud_vpc_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpc_v1.html opentelekomcloud_vpc_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcV1Config);
    private _cidr?;
    /**
     * @stability stable
     */
    get cidr(): string | undefined;
    /**
     * @stability stable
     */
    set cidr(value: string | undefined);
    /**
     * @stability stable
     */
    resetCidr(): void;
    /**
     * @stability stable
     */
    get cidrInput(): string | undefined;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string | undefined;
    /**
     * @stability stable
     */
    set id(value: string | undefined);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    routes(index: string): DataOpentelekomcloudVpcV1Routes;
    private _shared?;
    /**
     * @stability stable
     */
    get shared(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set shared(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetShared(): void;
    /**
     * @stability stable
     */
    get sharedInput(): boolean | cdktf.IResolvable | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
