import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataOpentelekomcloudVpcepServiceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1.html#name DataOpentelekomcloudVpcepServiceV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1.html#status DataOpentelekomcloudVpcepServiceV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1.html#tags DataOpentelekomcloudVpcepServiceV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcepServiceV1Port extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientPort(): number;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    get serverPort(): number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1.html opentelekomcloud_vpcep_service_v1}.
 *
 * @stability stable
 */
export declare class DataOpentelekomcloudVpcepServiceV1 extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/d/vpcep_service_v1.html opentelekomcloud_vpcep_service_v1} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataOpentelekomcloudVpcepServiceV1Config);
    /**
     * @stability stable
     */
    get approvalEnabled(): any;
    /**
     * @stability stable
     */
    get connectionCount(): number;
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    port(index: string): DataOpentelekomcloudVpcepServiceV1Port;
    /**
     * @stability stable
     */
    get portId(): string;
    /**
     * @stability stable
     */
    get projectId(): string;
    /**
     * @stability stable
     */
    get serverType(): string;
    /**
     * @stability stable
     */
    get serviceType(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tcpProxy(): string;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    /**
     * @stability stable
     */
    get vipPortId(): string;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
