import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DcsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#access_user DcsInstanceV1#access_user}.
     *
     * @stability stable
     */
    readonly accessUser?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#available_zones DcsInstanceV1#available_zones}.
     *
     * @stability stable
     */
    readonly availableZones: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#backup_at DcsInstanceV1#backup_at}.
     *
     * @stability stable
     */
    readonly backupAt?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#backup_type DcsInstanceV1#backup_type}.
     *
     * @stability stable
     */
    readonly backupType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#begin_at DcsInstanceV1#begin_at}.
     *
     * @stability stable
     */
    readonly beginAt?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#capacity DcsInstanceV1#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#description DcsInstanceV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#engine DcsInstanceV1#engine}.
     *
     * @stability stable
     */
    readonly engine: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#engine_version DcsInstanceV1#engine_version}.
     *
     * @stability stable
     */
    readonly engineVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#maintain_begin DcsInstanceV1#maintain_begin}.
     *
     * @stability stable
     */
    readonly maintainBegin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#maintain_end DcsInstanceV1#maintain_end}.
     *
     * @stability stable
     */
    readonly maintainEnd?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#name DcsInstanceV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#password DcsInstanceV1#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#period_type DcsInstanceV1#period_type}.
     *
     * @stability stable
     */
    readonly periodType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#product_id DcsInstanceV1#product_id}.
     *
     * @stability stable
     */
    readonly productId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#save_days DcsInstanceV1#save_days}.
     *
     * @stability stable
     */
    readonly saveDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#security_group_id DcsInstanceV1#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#subnet_id DcsInstanceV1#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#vpc_id DcsInstanceV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * backup_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#backup_policy DcsInstanceV1#backup_policy}
     *
     * @stability stable
     */
    readonly backupPolicy?: DcsInstanceV1BackupPolicy;
    /**
     * configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#configuration DcsInstanceV1#configuration}
     *
     * @stability stable
     */
    readonly configuration?: DcsInstanceV1Configuration[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#timeouts DcsInstanceV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DcsInstanceV1Timeouts;
}
/**
 * @stability stable
 */
export interface DcsInstanceV1BackupPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#backup_at DcsInstanceV1#backup_at}.
     *
     * @stability stable
     */
    readonly backupAt: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#backup_type DcsInstanceV1#backup_type}.
     *
     * @stability stable
     */
    readonly backupType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#begin_at DcsInstanceV1#begin_at}.
     *
     * @stability stable
     */
    readonly beginAt: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#period_type DcsInstanceV1#period_type}.
     *
     * @stability stable
     */
    readonly periodType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#save_days DcsInstanceV1#save_days}.
     *
     * @stability stable
     */
    readonly saveDays?: number;
}
/**
 * @stability stable
 */
export declare class DcsInstanceV1BackupPolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _backupAt?;
    /**
     * @stability stable
     */
    get backupAt(): number[];
    /**
     * @stability stable
     */
    set backupAt(value: number[]);
    /**
     * @stability stable
     */
    get backupAtInput(): number[] | undefined;
    private _backupType?;
    /**
     * @stability stable
     */
    get backupType(): string | undefined;
    /**
     * @stability stable
     */
    set backupType(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupType(): void;
    /**
     * @stability stable
     */
    get backupTypeInput(): string | undefined;
    private _beginAt?;
    /**
     * @stability stable
     */
    get beginAt(): string;
    /**
     * @stability stable
     */
    set beginAt(value: string);
    /**
     * @stability stable
     */
    get beginAtInput(): string | undefined;
    private _periodType?;
    /**
     * @stability stable
     */
    get periodType(): string;
    /**
     * @stability stable
     */
    set periodType(value: string);
    /**
     * @stability stable
     */
    get periodTypeInput(): string | undefined;
    private _saveDays?;
    /**
     * @stability stable
     */
    get saveDays(): number | undefined;
    /**
     * @stability stable
     */
    set saveDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetSaveDays(): void;
    /**
     * @stability stable
     */
    get saveDaysInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DcsInstanceV1Configuration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#parameter_id DcsInstanceV1#parameter_id}.
     *
     * @stability stable
     */
    readonly parameterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#parameter_name DcsInstanceV1#parameter_name}.
     *
     * @stability stable
     */
    readonly parameterName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#parameter_value DcsInstanceV1#parameter_value}.
     *
     * @stability stable
     */
    readonly parameterValue: string;
}
/**
 * @stability stable
 */
export interface DcsInstanceV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#create DcsInstanceV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#delete DcsInstanceV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html#update DcsInstanceV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DcsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html opentelekomcloud_dcs_instance_v1}.
 *
 * @stability stable
 */
export declare class DcsInstanceV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dcs_instance_v1.html opentelekomcloud_dcs_instance_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DcsInstanceV1Config);
    private _accessUser?;
    /**
     * @stability stable
     */
    get accessUser(): string | undefined;
    /**
     * @stability stable
     */
    set accessUser(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessUser(): void;
    /**
     * @stability stable
     */
    get accessUserInput(): string | undefined;
    private _availableZones?;
    /**
     * @stability stable
     */
    get availableZones(): string[];
    /**
     * @stability stable
     */
    set availableZones(value: string[]);
    /**
     * @stability stable
     */
    get availableZonesInput(): string[] | undefined;
    private _backupAt?;
    /**
     * @stability stable
     */
    get backupAt(): number[] | undefined;
    /**
     * @stability stable
     */
    set backupAt(value: number[] | undefined);
    /**
     * @stability stable
     */
    resetBackupAt(): void;
    /**
     * @stability stable
     */
    get backupAtInput(): number[] | undefined;
    private _backupType?;
    /**
     * @stability stable
     */
    get backupType(): string | undefined;
    /**
     * @stability stable
     */
    set backupType(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupType(): void;
    /**
     * @stability stable
     */
    get backupTypeInput(): string | undefined;
    private _beginAt?;
    /**
     * @stability stable
     */
    get beginAt(): string | undefined;
    /**
     * @stability stable
     */
    set beginAt(value: string | undefined);
    /**
     * @stability stable
     */
    resetBeginAt(): void;
    /**
     * @stability stable
     */
    get beginAtInput(): string | undefined;
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _engine?;
    /**
     * @stability stable
     */
    get engine(): string;
    /**
     * @stability stable
     */
    set engine(value: string);
    /**
     * @stability stable
     */
    get engineInput(): string | undefined;
    private _engineVersion?;
    /**
     * @stability stable
     */
    get engineVersion(): string;
    /**
     * @stability stable
     */
    set engineVersion(value: string);
    /**
     * @stability stable
     */
    get engineVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get internalVersion(): string;
    /**
     * @stability stable
     */
    get ip(): string;
    private _maintainBegin?;
    /**
     * @stability stable
     */
    get maintainBegin(): string | undefined;
    /**
     * @stability stable
     */
    set maintainBegin(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaintainBegin(): void;
    /**
     * @stability stable
     */
    get maintainBeginInput(): string | undefined;
    private _maintainEnd?;
    /**
     * @stability stable
     */
    get maintainEnd(): string | undefined;
    /**
     * @stability stable
     */
    set maintainEnd(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaintainEnd(): void;
    /**
     * @stability stable
     */
    get maintainEndInput(): string | undefined;
    /**
     * @stability stable
     */
    get maxMemory(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get orderId(): string;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _periodType?;
    /**
     * @stability stable
     */
    get periodType(): string | undefined;
    /**
     * @stability stable
     */
    set periodType(value: string | undefined);
    /**
     * @stability stable
     */
    resetPeriodType(): void;
    /**
     * @stability stable
     */
    get periodTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get port(): number;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string;
    /**
     * @stability stable
     */
    set productId(value: string);
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceSpecCode(): string;
    private _saveDays?;
    /**
     * @stability stable
     */
    get saveDays(): number | undefined;
    /**
     * @stability stable
     */
    set saveDays(value: number | undefined);
    /**
     * @stability stable
     */
    resetSaveDays(): void;
    /**
     * @stability stable
     */
    get saveDaysInput(): number | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get securityGroupName(): string;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetName(): string;
    /**
     * @stability stable
     */
    get usedMemory(): number;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    get userName(): string;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get vpcName(): string;
    private _backupPolicy?;
    private __backupPolicyOutput;
    /**
     * @stability stable
     */
    get backupPolicy(): DcsInstanceV1BackupPolicyOutputReference;
    /**
     * @stability stable
     */
    putBackupPolicy(value: DcsInstanceV1BackupPolicy | undefined): void;
    /**
     * @stability stable
     */
    resetBackupPolicy(): void;
    /**
     * @stability stable
     */
    get backupPolicyInput(): DcsInstanceV1BackupPolicy | undefined;
    private _configuration?;
    /**
     * @stability stable
     */
    get configuration(): DcsInstanceV1Configuration[] | undefined;
    /**
     * @stability stable
     */
    set configuration(value: DcsInstanceV1Configuration[] | undefined);
    /**
     * @stability stable
     */
    resetConfiguration(): void;
    /**
     * @stability stable
     */
    get configurationInput(): DcsInstanceV1Configuration[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DcsInstanceV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DcsInstanceV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DcsInstanceV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
