import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DdsInstanceV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#availability_zone DdsInstanceV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#disk_encryption_id DdsInstanceV3#disk_encryption_id}.
     *
     * @stability stable
     */
    readonly diskEncryptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#mode DdsInstanceV3#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#name DdsInstanceV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#password DdsInstanceV3#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#region DdsInstanceV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#security_group_id DdsInstanceV3#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#ssl DdsInstanceV3#ssl}.
     *
     * @stability stable
     */
    readonly ssl?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#subnet_id DdsInstanceV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#vpc_id DdsInstanceV3#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * backup_strategy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#backup_strategy DdsInstanceV3#backup_strategy}
     *
     * @stability stable
     */
    readonly backupStrategy?: DdsInstanceV3BackupStrategy;
    /**
     * datastore block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#datastore DdsInstanceV3#datastore}
     *
     * @stability stable
     */
    readonly datastore: DdsInstanceV3Datastore;
    /**
     * flavor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#flavor DdsInstanceV3#flavor}
     *
     * @stability stable
     */
    readonly flavor: DdsInstanceV3Flavor[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#timeouts DdsInstanceV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DdsInstanceV3Timeouts;
}
/**
 * @stability stable
 */
export declare class DdsInstanceV3Nodes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get privateIp(): string;
    /**
     * @stability stable
     */
    get publicIp(): string;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DdsInstanceV3BackupStrategy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#keep_days DdsInstanceV3#keep_days}.
     *
     * @stability stable
     */
    readonly keepDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#start_time DdsInstanceV3#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
/**
 * @stability stable
 */
export declare class DdsInstanceV3BackupStrategyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _keepDays?;
    /**
     * @stability stable
     */
    get keepDays(): number;
    /**
     * @stability stable
     */
    set keepDays(value: number);
    /**
     * @stability stable
     */
    get keepDaysInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DdsInstanceV3Datastore {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#storage_engine DdsInstanceV3#storage_engine}.
     *
     * @stability stable
     */
    readonly storageEngine?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#type DdsInstanceV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#version DdsInstanceV3#version}.
     *
     * @stability stable
     */
    readonly version: string;
}
/**
 * @stability stable
 */
export declare class DdsInstanceV3DatastoreOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _storageEngine?;
    /**
     * @stability stable
     */
    get storageEngine(): string | undefined;
    /**
     * @stability stable
     */
    set storageEngine(value: string | undefined);
    /**
     * @stability stable
     */
    resetStorageEngine(): void;
    /**
     * @stability stable
     */
    get storageEngineInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DdsInstanceV3Flavor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#num DdsInstanceV3#num}.
     *
     * @stability stable
     */
    readonly num: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#size DdsInstanceV3#size}.
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#spec_code DdsInstanceV3#spec_code}.
     *
     * @stability stable
     */
    readonly specCode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#storage DdsInstanceV3#storage}.
     *
     * @stability stable
     */
    readonly storage?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#type DdsInstanceV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface DdsInstanceV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#create DdsInstanceV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html#delete DdsInstanceV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class DdsInstanceV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html opentelekomcloud_dds_instance_v3}.
 *
 * @stability stable
 */
export declare class DdsInstanceV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dds_instance_v3.html opentelekomcloud_dds_instance_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DdsInstanceV3Config);
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    /**
     * @stability stable
     */
    get dbUsername(): string;
    private _diskEncryptionId?;
    /**
     * @stability stable
     */
    get diskEncryptionId(): string | undefined;
    /**
     * @stability stable
     */
    set diskEncryptionId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDiskEncryptionId(): void;
    /**
     * @stability stable
     */
    get diskEncryptionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    nodes(index: string): DdsInstanceV3Nodes;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    /**
     * @stability stable
     */
    get payMode(): string;
    /**
     * @stability stable
     */
    get port(): number;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    private _ssl?;
    /**
     * @stability stable
     */
    get ssl(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ssl(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSsl(): void;
    /**
     * @stability stable
     */
    get sslInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _backupStrategy?;
    private __backupStrategyOutput;
    /**
     * @stability stable
     */
    get backupStrategy(): DdsInstanceV3BackupStrategyOutputReference;
    /**
     * @stability stable
     */
    putBackupStrategy(value: DdsInstanceV3BackupStrategy | undefined): void;
    /**
     * @stability stable
     */
    resetBackupStrategy(): void;
    /**
     * @stability stable
     */
    get backupStrategyInput(): DdsInstanceV3BackupStrategy | undefined;
    private _datastore?;
    private __datastoreOutput;
    /**
     * @stability stable
     */
    get datastore(): DdsInstanceV3DatastoreOutputReference;
    /**
     * @stability stable
     */
    putDatastore(value: DdsInstanceV3Datastore): void;
    /**
     * @stability stable
     */
    get datastoreInput(): DdsInstanceV3Datastore | undefined;
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): DdsInstanceV3Flavor[];
    /**
     * @stability stable
     */
    set flavor(value: DdsInstanceV3Flavor[]);
    /**
     * @stability stable
     */
    get flavorInput(): DdsInstanceV3Flavor[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DdsInstanceV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DdsInstanceV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DdsInstanceV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
