import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DehHostV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#auto_placement DehHostV1#auto_placement}.
     *
     * @stability stable
     */
    readonly autoPlacement?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#availability_zone DehHostV1#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#available_memory DehHostV1#available_memory}.
     *
     * @stability stable
     */
    readonly availableMemory?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#available_vcpus DehHostV1#available_vcpus}.
     *
     * @stability stable
     */
    readonly availableVcpus?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#cores DehHostV1#cores}.
     *
     * @stability stable
     */
    readonly cores?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#host_type DehHostV1#host_type}.
     *
     * @stability stable
     */
    readonly hostType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#host_type_name DehHostV1#host_type_name}.
     *
     * @stability stable
     */
    readonly hostTypeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#instance_total DehHostV1#instance_total}.
     *
     * @stability stable
     */
    readonly instanceTotal?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#instance_uuids DehHostV1#instance_uuids}.
     *
     * @stability stable
     */
    readonly instanceUuids?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#memory DehHostV1#memory}.
     *
     * @stability stable
     */
    readonly memory?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#name DehHostV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#region DehHostV1#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#sockets DehHostV1#sockets}.
     *
     * @stability stable
     */
    readonly sockets?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#status DehHostV1#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#vcpus DehHostV1#vcpus}.
     *
     * @stability stable
     */
    readonly vcpus?: number;
    /**
     * available_instance_capacities block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#available_instance_capacities DehHostV1#available_instance_capacities}
     *
     * @stability stable
     */
    readonly availableInstanceCapacities?: DehHostV1AvailableInstanceCapacities[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#timeouts DehHostV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DehHostV1Timeouts;
}
/**
 * @stability stable
 */
export interface DehHostV1AvailableInstanceCapacities {
}
/**
 * @stability stable
 */
export interface DehHostV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#create DehHostV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html#delete DehHostV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class DehHostV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html opentelekomcloud_deh_host_v1}.
 *
 * @stability stable
 */
export declare class DehHostV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/deh_host_v1.html opentelekomcloud_deh_host_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DehHostV1Config);
    private _autoPlacement?;
    /**
     * @stability stable
     */
    get autoPlacement(): string | undefined;
    /**
     * @stability stable
     */
    set autoPlacement(value: string | undefined);
    /**
     * @stability stable
     */
    resetAutoPlacement(): void;
    /**
     * @stability stable
     */
    get autoPlacementInput(): string | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _availableMemory?;
    /**
     * @stability stable
     */
    get availableMemory(): number | undefined;
    /**
     * @stability stable
     */
    set availableMemory(value: number | undefined);
    /**
     * @stability stable
     */
    resetAvailableMemory(): void;
    /**
     * @stability stable
     */
    get availableMemoryInput(): number | undefined;
    private _availableVcpus?;
    /**
     * @stability stable
     */
    get availableVcpus(): number | undefined;
    /**
     * @stability stable
     */
    set availableVcpus(value: number | undefined);
    /**
     * @stability stable
     */
    resetAvailableVcpus(): void;
    /**
     * @stability stable
     */
    get availableVcpusInput(): number | undefined;
    private _cores?;
    /**
     * @stability stable
     */
    get cores(): number | undefined;
    /**
     * @stability stable
     */
    set cores(value: number | undefined);
    /**
     * @stability stable
     */
    resetCores(): void;
    /**
     * @stability stable
     */
    get coresInput(): number | undefined;
    private _hostType?;
    /**
     * @stability stable
     */
    get hostType(): string;
    /**
     * @stability stable
     */
    set hostType(value: string);
    /**
     * @stability stable
     */
    get hostTypeInput(): string | undefined;
    private _hostTypeName?;
    /**
     * @stability stable
     */
    get hostTypeName(): string | undefined;
    /**
     * @stability stable
     */
    set hostTypeName(value: string | undefined);
    /**
     * @stability stable
     */
    resetHostTypeName(): void;
    /**
     * @stability stable
     */
    get hostTypeNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instanceTotal?;
    /**
     * @stability stable
     */
    get instanceTotal(): number | undefined;
    /**
     * @stability stable
     */
    set instanceTotal(value: number | undefined);
    /**
     * @stability stable
     */
    resetInstanceTotal(): void;
    /**
     * @stability stable
     */
    get instanceTotalInput(): number | undefined;
    private _instanceUuids?;
    /**
     * @stability stable
     */
    get instanceUuids(): string[] | undefined;
    /**
     * @stability stable
     */
    set instanceUuids(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetInstanceUuids(): void;
    /**
     * @stability stable
     */
    get instanceUuidsInput(): string[] | undefined;
    private _memory?;
    /**
     * @stability stable
     */
    get memory(): number | undefined;
    /**
     * @stability stable
     */
    set memory(value: number | undefined);
    /**
     * @stability stable
     */
    resetMemory(): void;
    /**
     * @stability stable
     */
    get memoryInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _sockets?;
    /**
     * @stability stable
     */
    get sockets(): number | undefined;
    /**
     * @stability stable
     */
    set sockets(value: number | undefined);
    /**
     * @stability stable
     */
    resetSockets(): void;
    /**
     * @stability stable
     */
    get socketsInput(): number | undefined;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _vcpus?;
    /**
     * @stability stable
     */
    get vcpus(): number | undefined;
    /**
     * @stability stable
     */
    set vcpus(value: number | undefined);
    /**
     * @stability stable
     */
    resetVcpus(): void;
    /**
     * @stability stable
     */
    get vcpusInput(): number | undefined;
    private _availableInstanceCapacities?;
    /**
     * @stability stable
     */
    get availableInstanceCapacities(): DehHostV1AvailableInstanceCapacities[] | undefined;
    /**
     * @stability stable
     */
    set availableInstanceCapacities(value: DehHostV1AvailableInstanceCapacities[] | undefined);
    /**
     * @stability stable
     */
    resetAvailableInstanceCapacities(): void;
    /**
     * @stability stable
     */
    get availableInstanceCapacitiesInput(): DehHostV1AvailableInstanceCapacities[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DehHostV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DehHostV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DehHostV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
