import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DmsGroupV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1.html#name DmsGroupV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1.html#queue_id DmsGroupV1#queue_id}.
     *
     * @stability stable
     */
    readonly queueId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1.html opentelekomcloud_dms_group_v1}.
 *
 * @stability stable
 */
export declare class DmsGroupV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_group_v1.html opentelekomcloud_dms_group_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DmsGroupV1Config);
    /**
     * @stability stable
     */
    get availableDeadletters(): number;
    /**
     * @stability stable
     */
    get availableMessages(): number;
    /**
     * @stability stable
     */
    get consumedMessages(): number;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get producedDeadletters(): number;
    /**
     * @stability stable
     */
    get producedMessages(): number;
    private _queueId?;
    /**
     * @stability stable
     */
    get queueId(): string;
    /**
     * @stability stable
     */
    set queueId(value: string);
    /**
     * @stability stable
     */
    get queueIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
