import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DmsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#access_user DmsInstanceV1#access_user}.
     *
     * @stability stable
     */
    readonly accessUser?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#available_zones DmsInstanceV1#available_zones}.
     *
     * @stability stable
     */
    readonly availableZones: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#description DmsInstanceV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#engine DmsInstanceV1#engine}.
     *
     * @stability stable
     */
    readonly engine: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#engine_version DmsInstanceV1#engine_version}.
     *
     * @stability stable
     */
    readonly engineVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#maintain_begin DmsInstanceV1#maintain_begin}.
     *
     * @stability stable
     */
    readonly maintainBegin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#maintain_end DmsInstanceV1#maintain_end}.
     *
     * @stability stable
     */
    readonly maintainEnd?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#name DmsInstanceV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#partition_num DmsInstanceV1#partition_num}.
     *
     * @stability stable
     */
    readonly partitionNum?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#password DmsInstanceV1#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#product_id DmsInstanceV1#product_id}.
     *
     * @stability stable
     */
    readonly productId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#retention_policy DmsInstanceV1#retention_policy}.
     *
     * @stability stable
     */
    readonly retentionPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#security_group_id DmsInstanceV1#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#specification DmsInstanceV1#specification}.
     *
     * @stability stable
     */
    readonly specification?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#storage_space DmsInstanceV1#storage_space}.
     *
     * @stability stable
     */
    readonly storageSpace: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#storage_spec_code DmsInstanceV1#storage_spec_code}.
     *
     * @stability stable
     */
    readonly storageSpecCode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#subnet_id DmsInstanceV1#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html#vpc_id DmsInstanceV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html opentelekomcloud_dms_instance_v1}.
 *
 * @stability stable
 */
export declare class DmsInstanceV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_instance_v1.html opentelekomcloud_dms_instance_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DmsInstanceV1Config);
    private _accessUser?;
    /**
     * @stability stable
     */
    get accessUser(): string | undefined;
    /**
     * @stability stable
     */
    set accessUser(value: string | undefined);
    /**
     * @stability stable
     */
    resetAccessUser(): void;
    /**
     * @stability stable
     */
    get accessUserInput(): string | undefined;
    private _availableZones?;
    /**
     * @stability stable
     */
    get availableZones(): string[];
    /**
     * @stability stable
     */
    set availableZones(value: string[]);
    /**
     * @stability stable
     */
    get availableZonesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get connectAddress(): string;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _engine?;
    /**
     * @stability stable
     */
    get engine(): string;
    /**
     * @stability stable
     */
    set engine(value: string);
    /**
     * @stability stable
     */
    get engineInput(): string | undefined;
    private _engineVersion?;
    /**
     * @stability stable
     */
    get engineVersion(): string;
    /**
     * @stability stable
     */
    set engineVersion(value: string);
    /**
     * @stability stable
     */
    get engineVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maintainBegin?;
    /**
     * @stability stable
     */
    get maintainBegin(): string | undefined;
    /**
     * @stability stable
     */
    set maintainBegin(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaintainBegin(): void;
    /**
     * @stability stable
     */
    get maintainBeginInput(): string | undefined;
    private _maintainEnd?;
    /**
     * @stability stable
     */
    get maintainEnd(): string | undefined;
    /**
     * @stability stable
     */
    set maintainEnd(value: string | undefined);
    /**
     * @stability stable
     */
    resetMaintainEnd(): void;
    /**
     * @stability stable
     */
    get maintainEndInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get orderId(): string;
    private _partitionNum?;
    /**
     * @stability stable
     */
    get partitionNum(): number | undefined;
    /**
     * @stability stable
     */
    set partitionNum(value: number | undefined);
    /**
     * @stability stable
     */
    resetPartitionNum(): void;
    /**
     * @stability stable
     */
    get partitionNumInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    /**
     * @stability stable
     */
    get port(): number;
    private _productId?;
    /**
     * @stability stable
     */
    get productId(): string;
    /**
     * @stability stable
     */
    set productId(value: string);
    /**
     * @stability stable
     */
    get productIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceSpecCode(): string;
    private _retentionPolicy?;
    /**
     * @stability stable
     */
    get retentionPolicy(): string | undefined;
    /**
     * @stability stable
     */
    set retentionPolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): string | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get securityGroupName(): string;
    private _specification?;
    /**
     * @stability stable
     */
    get specification(): string | undefined;
    /**
     * @stability stable
     */
    set specification(value: string | undefined);
    /**
     * @stability stable
     */
    resetSpecification(): void;
    /**
     * @stability stable
     */
    get specificationInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    private _storageSpace?;
    /**
     * @stability stable
     */
    get storageSpace(): number;
    /**
     * @stability stable
     */
    set storageSpace(value: number);
    /**
     * @stability stable
     */
    get storageSpaceInput(): number | undefined;
    private _storageSpecCode?;
    /**
     * @stability stable
     */
    get storageSpecCode(): string;
    /**
     * @stability stable
     */
    set storageSpecCode(value: string);
    /**
     * @stability stable
     */
    get storageSpecCodeInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get subnetName(): string;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get usedStorageSpace(): number;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    get userName(): string;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get vpcName(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
