import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DmsQueueV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#description DmsQueueV1#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#max_consume_count DmsQueueV1#max_consume_count}.
     *
     * @stability stable
     */
    readonly maxConsumeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#name DmsQueueV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#queue_mode DmsQueueV1#queue_mode}.
     *
     * @stability stable
     */
    readonly queueMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#redrive_policy DmsQueueV1#redrive_policy}.
     *
     * @stability stable
     */
    readonly redrivePolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html#retention_hours DmsQueueV1#retention_hours}.
     *
     * @stability stable
     */
    readonly retentionHours?: number;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html opentelekomcloud_dms_queue_v1}.
 *
 * @stability stable
 */
export declare class DmsQueueV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dms_queue_v1.html opentelekomcloud_dms_queue_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DmsQueueV1Config);
    /**
     * @stability stable
     */
    get created(): number;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get groupCount(): number;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxConsumeCount?;
    /**
     * @stability stable
     */
    get maxConsumeCount(): number | undefined;
    /**
     * @stability stable
     */
    set maxConsumeCount(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxConsumeCount(): void;
    /**
     * @stability stable
     */
    get maxConsumeCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get maxMsgSizeByte(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get producedMessages(): number;
    private _queueMode?;
    /**
     * @stability stable
     */
    get queueMode(): string | undefined;
    /**
     * @stability stable
     */
    set queueMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetQueueMode(): void;
    /**
     * @stability stable
     */
    get queueModeInput(): string | undefined;
    private _redrivePolicy?;
    /**
     * @stability stable
     */
    get redrivePolicy(): string | undefined;
    /**
     * @stability stable
     */
    set redrivePolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetRedrivePolicy(): void;
    /**
     * @stability stable
     */
    get redrivePolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get reservation(): number;
    private _retentionHours?;
    /**
     * @stability stable
     */
    get retentionHours(): number | undefined;
    /**
     * @stability stable
     */
    set retentionHours(value: number | undefined);
    /**
     * @stability stable
     */
    resetRetentionHours(): void;
    /**
     * @stability stable
     */
    get retentionHoursInput(): number | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
