import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsZoneV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#description DnsZoneV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#email DnsZoneV2#email}.
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#name DnsZoneV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#region DnsZoneV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#tags DnsZoneV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#ttl DnsZoneV2#ttl}.
     *
     * @stability stable
     */
    readonly ttl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#type DnsZoneV2#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#value_specs DnsZoneV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * router block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#router DnsZoneV2#router}
     *
     * @stability stable
     */
    readonly router?: DnsZoneV2Router[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#timeouts DnsZoneV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsZoneV2Timeouts;
}
/**
 * @stability stable
 */
export interface DnsZoneV2Router {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#router_id DnsZoneV2#router_id}.
     *
     * @stability stable
     */
    readonly routerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#router_region DnsZoneV2#router_region}.
     *
     * @stability stable
     */
    readonly routerRegion: string;
}
/**
 * @stability stable
 */
export interface DnsZoneV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#create DnsZoneV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#delete DnsZoneV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html#update DnsZoneV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DnsZoneV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html opentelekomcloud_dns_zone_v2}.
 *
 * @stability stable
 */
export declare class DnsZoneV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/dns_zone_v2.html opentelekomcloud_dns_zone_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsZoneV2Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string | undefined;
    /**
     * @stability stable
     */
    set email(value: string | undefined);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get masters(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number | undefined;
    /**
     * @stability stable
     */
    set ttl(value: number | undefined);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): DnsZoneV2Router[] | undefined;
    /**
     * @stability stable
     */
    set router(value: DnsZoneV2Router[] | undefined);
    /**
     * @stability stable
     */
    resetRouter(): void;
    /**
     * @stability stable
     */
    get routerInput(): DnsZoneV2Router[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DnsZoneV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsZoneV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsZoneV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
