import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EcsInstanceV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#auto_recovery EcsInstanceV1#auto_recovery}.
     *
     * @stability stable
     */
    readonly autoRecovery?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#availability_zone EcsInstanceV1#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#delete_disks_on_termination EcsInstanceV1#delete_disks_on_termination}.
     *
     * @stability stable
     */
    readonly deleteDisksOnTermination?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#flavor EcsInstanceV1#flavor}.
     *
     * @stability stable
     */
    readonly flavor: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#image_id EcsInstanceV1#image_id}.
     *
     * @stability stable
     */
    readonly imageId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#key_name EcsInstanceV1#key_name}.
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#name EcsInstanceV1#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#password EcsInstanceV1#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#security_groups EcsInstanceV1#security_groups}.
     *
     * @stability stable
     */
    readonly securityGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#system_disk_size EcsInstanceV1#system_disk_size}.
     *
     * @stability stable
     */
    readonly systemDiskSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#system_disk_type EcsInstanceV1#system_disk_type}.
     *
     * @stability stable
     */
    readonly systemDiskType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#tags EcsInstanceV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#user_data EcsInstanceV1#user_data}.
     *
     * @stability stable
     */
    readonly userData?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#vpc_id EcsInstanceV1#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * data_disks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#data_disks EcsInstanceV1#data_disks}
     *
     * @stability stable
     */
    readonly dataDisks?: EcsInstanceV1DataDisks[];
    /**
     * nics block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#nics EcsInstanceV1#nics}
     *
     * @stability stable
     */
    readonly nics: EcsInstanceV1Nics[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#timeouts EcsInstanceV1#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EcsInstanceV1Timeouts;
}
/**
 * @stability stable
 */
export interface EcsInstanceV1DataDisks {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#kms_id EcsInstanceV1#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#size EcsInstanceV1#size}.
     *
     * @stability stable
     */
    readonly size: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#snapshot_id EcsInstanceV1#snapshot_id}.
     *
     * @stability stable
     */
    readonly snapshotId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#type EcsInstanceV1#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
/**
 * @stability stable
 */
export interface EcsInstanceV1Nics {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#ip_address EcsInstanceV1#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#network_id EcsInstanceV1#network_id}.
     *
     * @stability stable
     */
    readonly networkId: string;
}
/**
 * @stability stable
 */
export interface EcsInstanceV1Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#create EcsInstanceV1#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#delete EcsInstanceV1#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html#update EcsInstanceV1#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class EcsInstanceV1TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html opentelekomcloud_ecs_instance_v1}.
 *
 * @stability stable
 */
export declare class EcsInstanceV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ecs_instance_v1.html opentelekomcloud_ecs_instance_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EcsInstanceV1Config);
    private _autoRecovery?;
    /**
     * @stability stable
     */
    get autoRecovery(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set autoRecovery(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAutoRecovery(): void;
    /**
     * @stability stable
     */
    get autoRecoveryInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _deleteDisksOnTermination?;
    /**
     * @stability stable
     */
    get deleteDisksOnTermination(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set deleteDisksOnTermination(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDeleteDisksOnTermination(): void;
    /**
     * @stability stable
     */
    get deleteDisksOnTerminationInput(): boolean | cdktf.IResolvable | undefined;
    private _flavor?;
    /**
     * @stability stable
     */
    get flavor(): string;
    /**
     * @stability stable
     */
    set flavor(value: string);
    /**
     * @stability stable
     */
    get flavorInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string;
    /**
     * @stability stable
     */
    set imageId(value: string);
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string | undefined;
    /**
     * @stability stable
     */
    set keyName(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyName(): void;
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _securityGroups?;
    /**
     * @stability stable
     */
    get securityGroups(): string[] | undefined;
    /**
     * @stability stable
     */
    set securityGroups(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroups(): void;
    /**
     * @stability stable
     */
    get securityGroupsInput(): string[] | undefined;
    private _systemDiskSize?;
    /**
     * @stability stable
     */
    get systemDiskSize(): number | undefined;
    /**
     * @stability stable
     */
    set systemDiskSize(value: number | undefined);
    /**
     * @stability stable
     */
    resetSystemDiskSize(): void;
    /**
     * @stability stable
     */
    get systemDiskSizeInput(): number | undefined;
    private _systemDiskType?;
    /**
     * @stability stable
     */
    get systemDiskType(): string | undefined;
    /**
     * @stability stable
     */
    set systemDiskType(value: string | undefined);
    /**
     * @stability stable
     */
    resetSystemDiskType(): void;
    /**
     * @stability stable
     */
    get systemDiskTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _userData?;
    /**
     * @stability stable
     */
    get userData(): string | undefined;
    /**
     * @stability stable
     */
    set userData(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserData(): void;
    /**
     * @stability stable
     */
    get userDataInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _dataDisks?;
    /**
     * @stability stable
     */
    get dataDisks(): EcsInstanceV1DataDisks[] | undefined;
    /**
     * @stability stable
     */
    set dataDisks(value: EcsInstanceV1DataDisks[] | undefined);
    /**
     * @stability stable
     */
    resetDataDisks(): void;
    /**
     * @stability stable
     */
    get dataDisksInput(): EcsInstanceV1DataDisks[] | undefined;
    private _nics?;
    /**
     * @stability stable
     */
    get nics(): EcsInstanceV1Nics[];
    /**
     * @stability stable
     */
    set nics(value: EcsInstanceV1Nics[]);
    /**
     * @stability stable
     */
    get nicsInput(): EcsInstanceV1Nics[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): EcsInstanceV1TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EcsInstanceV1Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EcsInstanceV1Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
