import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ElbHealthConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthcheck_connect_port ElbHealth#healthcheck_connect_port}.
     *
     * @stability stable
     */
    readonly healthcheckConnectPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthcheck_interval ElbHealth#healthcheck_interval}.
     *
     * @stability stable
     */
    readonly healthcheckInterval?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthcheck_protocol ElbHealth#healthcheck_protocol}.
     *
     * @stability stable
     */
    readonly healthcheckProtocol?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthcheck_timeout ElbHealth#healthcheck_timeout}.
     *
     * @stability stable
     */
    readonly healthcheckTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthcheck_uri ElbHealth#healthcheck_uri}.
     *
     * @stability stable
     */
    readonly healthcheckUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#healthy_threshold ElbHealth#healthy_threshold}.
     *
     * @stability stable
     */
    readonly healthyThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#listener_id ElbHealth#listener_id}.
     *
     * @stability stable
     */
    readonly listenerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#region ElbHealth#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#unhealthy_threshold ElbHealth#unhealthy_threshold}.
     *
     * @stability stable
     */
    readonly unhealthyThreshold?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#timeouts ElbHealth#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ElbHealthTimeouts;
}
/**
 * @stability stable
 */
export interface ElbHealthTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#create ElbHealth#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#delete ElbHealth#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html#update ElbHealth#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ElbHealthTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html opentelekomcloud_elb_health}.
 *
 * @stability stable
 */
export declare class ElbHealth extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_health.html opentelekomcloud_elb_health} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ElbHealthConfig);
    private _healthcheckConnectPort?;
    /**
     * @stability stable
     */
    get healthcheckConnectPort(): number | undefined;
    /**
     * @stability stable
     */
    set healthcheckConnectPort(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthcheckConnectPort(): void;
    /**
     * @stability stable
     */
    get healthcheckConnectPortInput(): number | undefined;
    private _healthcheckInterval?;
    /**
     * @stability stable
     */
    get healthcheckInterval(): number | undefined;
    /**
     * @stability stable
     */
    set healthcheckInterval(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthcheckInterval(): void;
    /**
     * @stability stable
     */
    get healthcheckIntervalInput(): number | undefined;
    private _healthcheckProtocol?;
    /**
     * @stability stable
     */
    get healthcheckProtocol(): string | undefined;
    /**
     * @stability stable
     */
    set healthcheckProtocol(value: string | undefined);
    /**
     * @stability stable
     */
    resetHealthcheckProtocol(): void;
    /**
     * @stability stable
     */
    get healthcheckProtocolInput(): string | undefined;
    private _healthcheckTimeout?;
    /**
     * @stability stable
     */
    get healthcheckTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set healthcheckTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthcheckTimeout(): void;
    /**
     * @stability stable
     */
    get healthcheckTimeoutInput(): number | undefined;
    private _healthcheckUri?;
    /**
     * @stability stable
     */
    get healthcheckUri(): string | undefined;
    /**
     * @stability stable
     */
    set healthcheckUri(value: string | undefined);
    /**
     * @stability stable
     */
    resetHealthcheckUri(): void;
    /**
     * @stability stable
     */
    get healthcheckUriInput(): string | undefined;
    private _healthyThreshold?;
    /**
     * @stability stable
     */
    get healthyThreshold(): number | undefined;
    /**
     * @stability stable
     */
    set healthyThreshold(value: number | undefined);
    /**
     * @stability stable
     */
    resetHealthyThreshold(): void;
    /**
     * @stability stable
     */
    get healthyThresholdInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _listenerId?;
    /**
     * @stability stable
     */
    get listenerId(): string;
    /**
     * @stability stable
     */
    set listenerId(value: string);
    /**
     * @stability stable
     */
    get listenerIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _unhealthyThreshold?;
    /**
     * @stability stable
     */
    get unhealthyThreshold(): number | undefined;
    /**
     * @stability stable
     */
    set unhealthyThreshold(value: number | undefined);
    /**
     * @stability stable
     */
    resetUnhealthyThreshold(): void;
    /**
     * @stability stable
     */
    get unhealthyThresholdInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ElbHealthTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ElbHealthTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ElbHealthTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
