import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ElbListenerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#backend_port ElbListener#backend_port}.
     *
     * @stability stable
     */
    readonly backendPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#backend_protocol ElbListener#backend_protocol}.
     *
     * @stability stable
     */
    readonly backendProtocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#certificate_id ElbListener#certificate_id}.
     *
     * @stability stable
     */
    readonly certificateId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#certificates ElbListener#certificates}.
     *
     * @stability stable
     */
    readonly certificates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#cookie_timeout ElbListener#cookie_timeout}.
     *
     * @stability stable
     */
    readonly cookieTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#description ElbListener#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#lb_algorithm ElbListener#lb_algorithm}.
     *
     * @stability stable
     */
    readonly lbAlgorithm: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#loadbalancer_id ElbListener#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#name ElbListener#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#protocol ElbListener#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#protocol_port ElbListener#protocol_port}.
     *
     * @stability stable
     */
    readonly protocolPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#region ElbListener#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#session_sticky ElbListener#session_sticky}.
     *
     * @stability stable
     */
    readonly sessionSticky?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#session_sticky_type ElbListener#session_sticky_type}.
     *
     * @stability stable
     */
    readonly sessionStickyType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#ssl_ciphers ElbListener#ssl_ciphers}.
     *
     * @stability stable
     */
    readonly sslCiphers?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#ssl_protocols ElbListener#ssl_protocols}.
     *
     * @stability stable
     */
    readonly sslProtocols?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#tcp_draining ElbListener#tcp_draining}.
     *
     * @stability stable
     */
    readonly tcpDraining?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#tcp_draining_timeout ElbListener#tcp_draining_timeout}.
     *
     * @stability stable
     */
    readonly tcpDrainingTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#tcp_timeout ElbListener#tcp_timeout}.
     *
     * @stability stable
     */
    readonly tcpTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#udp_timeout ElbListener#udp_timeout}.
     *
     * @stability stable
     */
    readonly udpTimeout?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#timeouts ElbListener#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ElbListenerTimeouts;
}
/**
 * @stability stable
 */
export interface ElbListenerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#create ElbListener#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#delete ElbListener#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html#update ElbListener#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ElbListenerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html opentelekomcloud_elb_listener}.
 *
 * @stability stable
 */
export declare class ElbListener extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_listener.html opentelekomcloud_elb_listener} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ElbListenerConfig);
    private _backendPort?;
    /**
     * @stability stable
     */
    get backendPort(): number;
    /**
     * @stability stable
     */
    set backendPort(value: number);
    /**
     * @stability stable
     */
    get backendPortInput(): number | undefined;
    private _backendProtocol?;
    /**
     * @stability stable
     */
    get backendProtocol(): string;
    /**
     * @stability stable
     */
    set backendProtocol(value: string);
    /**
     * @stability stable
     */
    get backendProtocolInput(): string | undefined;
    private _certificateId?;
    /**
     * @stability stable
     */
    get certificateId(): string | undefined;
    /**
     * @stability stable
     */
    set certificateId(value: string | undefined);
    /**
     * @stability stable
     */
    resetCertificateId(): void;
    /**
     * @stability stable
     */
    get certificateIdInput(): string | undefined;
    private _certificates?;
    /**
     * @stability stable
     */
    get certificates(): string[] | undefined;
    /**
     * @stability stable
     */
    set certificates(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetCertificates(): void;
    /**
     * @stability stable
     */
    get certificatesInput(): string[] | undefined;
    private _cookieTimeout?;
    /**
     * @stability stable
     */
    get cookieTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set cookieTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetCookieTimeout(): void;
    /**
     * @stability stable
     */
    get cookieTimeoutInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lbAlgorithm?;
    /**
     * @stability stable
     */
    get lbAlgorithm(): string;
    /**
     * @stability stable
     */
    set lbAlgorithm(value: string);
    /**
     * @stability stable
     */
    get lbAlgorithmInput(): string | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _protocolPort?;
    /**
     * @stability stable
     */
    get protocolPort(): number;
    /**
     * @stability stable
     */
    set protocolPort(value: number);
    /**
     * @stability stable
     */
    get protocolPortInput(): number | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _sessionSticky?;
    /**
     * @stability stable
     */
    get sessionSticky(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set sessionSticky(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetSessionSticky(): void;
    /**
     * @stability stable
     */
    get sessionStickyInput(): boolean | cdktf.IResolvable | undefined;
    private _sessionStickyType?;
    /**
     * @stability stable
     */
    get sessionStickyType(): string | undefined;
    /**
     * @stability stable
     */
    set sessionStickyType(value: string | undefined);
    /**
     * @stability stable
     */
    resetSessionStickyType(): void;
    /**
     * @stability stable
     */
    get sessionStickyTypeInput(): string | undefined;
    private _sslCiphers?;
    /**
     * @stability stable
     */
    get sslCiphers(): string | undefined;
    /**
     * @stability stable
     */
    set sslCiphers(value: string | undefined);
    /**
     * @stability stable
     */
    resetSslCiphers(): void;
    /**
     * @stability stable
     */
    get sslCiphersInput(): string | undefined;
    private _sslProtocols?;
    /**
     * @stability stable
     */
    get sslProtocols(): string | undefined;
    /**
     * @stability stable
     */
    set sslProtocols(value: string | undefined);
    /**
     * @stability stable
     */
    resetSslProtocols(): void;
    /**
     * @stability stable
     */
    get sslProtocolsInput(): string | undefined;
    private _tcpDraining?;
    /**
     * @stability stable
     */
    get tcpDraining(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tcpDraining(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTcpDraining(): void;
    /**
     * @stability stable
     */
    get tcpDrainingInput(): boolean | cdktf.IResolvable | undefined;
    private _tcpDrainingTimeout?;
    /**
     * @stability stable
     */
    get tcpDrainingTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set tcpDrainingTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetTcpDrainingTimeout(): void;
    /**
     * @stability stable
     */
    get tcpDrainingTimeoutInput(): number | undefined;
    private _tcpTimeout?;
    /**
     * @stability stable
     */
    get tcpTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set tcpTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetTcpTimeout(): void;
    /**
     * @stability stable
     */
    get tcpTimeoutInput(): number | undefined;
    private _udpTimeout?;
    /**
     * @stability stable
     */
    get udpTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set udpTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetUdpTimeout(): void;
    /**
     * @stability stable
     */
    get udpTimeoutInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ElbListenerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ElbListenerTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ElbListenerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
