import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ElbLoadbalancerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#admin_state_up ElbLoadbalancer#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#az ElbLoadbalancer#az}.
     *
     * @stability stable
     */
    readonly az?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#bandwidth ElbLoadbalancer#bandwidth}.
     *
     * @stability stable
     */
    readonly bandwidth?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#description ElbLoadbalancer#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#name ElbLoadbalancer#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#region ElbLoadbalancer#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#security_group_id ElbLoadbalancer#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#type ElbLoadbalancer#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#vip_address ElbLoadbalancer#vip_address}.
     *
     * @stability stable
     */
    readonly vipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#vip_subnet_id ElbLoadbalancer#vip_subnet_id}.
     *
     * @stability stable
     */
    readonly vipSubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#vpc_id ElbLoadbalancer#vpc_id}.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#timeouts ElbLoadbalancer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ElbLoadbalancerTimeouts;
}
/**
 * @stability stable
 */
export interface ElbLoadbalancerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#create ElbLoadbalancer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#delete ElbLoadbalancer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html#update ElbLoadbalancer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class ElbLoadbalancerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html opentelekomcloud_elb_loadbalancer}.
 *
 * @stability stable
 */
export declare class ElbLoadbalancer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/elb_loadbalancer.html opentelekomcloud_elb_loadbalancer} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ElbLoadbalancerConfig);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _az?;
    /**
     * @stability stable
     */
    get az(): string | undefined;
    /**
     * @stability stable
     */
    set az(value: string | undefined);
    /**
     * @stability stable
     */
    resetAz(): void;
    /**
     * @stability stable
     */
    get azInput(): string | undefined;
    private _bandwidth?;
    /**
     * @stability stable
     */
    get bandwidth(): number | undefined;
    /**
     * @stability stable
     */
    set bandwidth(value: number | undefined);
    /**
     * @stability stable
     */
    resetBandwidth(): void;
    /**
     * @stability stable
     */
    get bandwidthInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string | undefined;
    /**
     * @stability stable
     */
    set securityGroupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSecurityGroupId(): void;
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _vipAddress?;
    /**
     * @stability stable
     */
    get vipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set vipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipAddress(): void;
    /**
     * @stability stable
     */
    get vipAddressInput(): string | undefined;
    private _vipSubnetId?;
    /**
     * @stability stable
     */
    get vipSubnetId(): string | undefined;
    /**
     * @stability stable
     */
    set vipSubnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipSubnetId(): void;
    /**
     * @stability stable
     */
    get vipSubnetIdInput(): string | undefined;
    private _vpcId?;
    /**
     * @stability stable
     */
    get vpcId(): string;
    /**
     * @stability stable
     */
    set vpcId(value: string);
    /**
     * @stability stable
     */
    get vpcIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ElbLoadbalancerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ElbLoadbalancerTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ElbLoadbalancerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
