import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EvsVolumeV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#availability_zone EvsVolumeV3#availability_zone}.
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#backup_id EvsVolumeV3#backup_id}.
     *
     * @stability stable
     */
    readonly backupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#cascade EvsVolumeV3#cascade}.
     *
     * @stability stable
     */
    readonly cascade?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#description EvsVolumeV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#device_type EvsVolumeV3#device_type}.
     *
     * @stability stable
     */
    readonly deviceType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#image_id EvsVolumeV3#image_id}.
     *
     * @stability stable
     */
    readonly imageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#kms_id EvsVolumeV3#kms_id}.
     *
     * @stability stable
     */
    readonly kmsId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#multiattach EvsVolumeV3#multiattach}.
     *
     * @stability stable
     */
    readonly multiattach?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#name EvsVolumeV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#size EvsVolumeV3#size}.
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#snapshot_id EvsVolumeV3#snapshot_id}.
     *
     * @stability stable
     */
    readonly snapshotId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#tags EvsVolumeV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#volume_type EvsVolumeV3#volume_type}.
     *
     * @stability stable
     */
    readonly volumeType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#timeouts EvsVolumeV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EvsVolumeV3Timeouts;
}
/**
 * @stability stable
 */
export declare class EvsVolumeV3Attachment extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get device(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get instanceId(): string;
}
/**
 * @stability stable
 */
export interface EvsVolumeV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#create EvsVolumeV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html#delete EvsVolumeV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class EvsVolumeV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html opentelekomcloud_evs_volume_v3}.
 *
 * @stability stable
 */
export declare class EvsVolumeV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/evs_volume_v3.html opentelekomcloud_evs_volume_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EvsVolumeV3Config);
    /**
     * @stability stable
     */
    attachment(index: string): EvsVolumeV3Attachment;
    private _availabilityZone?;
    /**
     * @stability stable
     */
    get availabilityZone(): string;
    /**
     * @stability stable
     */
    set availabilityZone(value: string);
    /**
     * @stability stable
     */
    get availabilityZoneInput(): string | undefined;
    private _backupId?;
    /**
     * @stability stable
     */
    get backupId(): string | undefined;
    /**
     * @stability stable
     */
    set backupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetBackupId(): void;
    /**
     * @stability stable
     */
    get backupIdInput(): string | undefined;
    private _cascade?;
    /**
     * @stability stable
     */
    get cascade(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set cascade(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetCascade(): void;
    /**
     * @stability stable
     */
    get cascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _deviceType?;
    /**
     * @stability stable
     */
    get deviceType(): string | undefined;
    /**
     * @stability stable
     */
    set deviceType(value: string | undefined);
    /**
     * @stability stable
     */
    resetDeviceType(): void;
    /**
     * @stability stable
     */
    get deviceTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string | undefined;
    /**
     * @stability stable
     */
    set imageId(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageId(): void;
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _kmsId?;
    /**
     * @stability stable
     */
    get kmsId(): string | undefined;
    /**
     * @stability stable
     */
    set kmsId(value: string | undefined);
    /**
     * @stability stable
     */
    resetKmsId(): void;
    /**
     * @stability stable
     */
    get kmsIdInput(): string | undefined;
    private _multiattach?;
    /**
     * @stability stable
     */
    get multiattach(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set multiattach(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMultiattach(): void;
    /**
     * @stability stable
     */
    get multiattachInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number | undefined;
    /**
     * @stability stable
     */
    set size(value: number | undefined);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _snapshotId?;
    /**
     * @stability stable
     */
    get snapshotId(): string | undefined;
    /**
     * @stability stable
     */
    set snapshotId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSnapshotId(): void;
    /**
     * @stability stable
     */
    get snapshotIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _volumeType?;
    /**
     * @stability stable
     */
    get volumeType(): string;
    /**
     * @stability stable
     */
    set volumeType(value: string);
    /**
     * @stability stable
     */
    get volumeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get wwn(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): EvsVolumeV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EvsVolumeV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EvsVolumeV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
