import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FwRuleV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#action FwRuleV2#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#description FwRuleV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#destination_ip_address FwRuleV2#destination_ip_address}.
     *
     * @stability stable
     */
    readonly destinationIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#destination_port FwRuleV2#destination_port}.
     *
     * @stability stable
     */
    readonly destinationPort?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#enabled FwRuleV2#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#ip_version FwRuleV2#ip_version}.
     *
     * @stability stable
     */
    readonly ipVersion?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#name FwRuleV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#protocol FwRuleV2#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#region FwRuleV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#source_ip_address FwRuleV2#source_ip_address}.
     *
     * @stability stable
     */
    readonly sourceIpAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#source_port FwRuleV2#source_port}.
     *
     * @stability stable
     */
    readonly sourcePort?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#tenant_id FwRuleV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html#value_specs FwRuleV2#value_specs}.
     *
     * @stability stable
     */
    readonly valueSpecs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html opentelekomcloud_fw_rule_v2}.
 *
 * @stability stable
 */
export declare class FwRuleV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/fw_rule_v2.html opentelekomcloud_fw_rule_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FwRuleV2Config);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destinationIpAddress?;
    /**
     * @stability stable
     */
    get destinationIpAddress(): string | undefined;
    /**
     * @stability stable
     */
    set destinationIpAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetDestinationIpAddress(): void;
    /**
     * @stability stable
     */
    get destinationIpAddressInput(): string | undefined;
    private _destinationPort?;
    /**
     * @stability stable
     */
    get destinationPort(): string | undefined;
    /**
     * @stability stable
     */
    set destinationPort(value: string | undefined);
    /**
     * @stability stable
     */
    resetDestinationPort(): void;
    /**
     * @stability stable
     */
    get destinationPortInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipVersion?;
    /**
     * @stability stable
     */
    get ipVersion(): number | undefined;
    /**
     * @stability stable
     */
    set ipVersion(value: number | undefined);
    /**
     * @stability stable
     */
    resetIpVersion(): void;
    /**
     * @stability stable
     */
    get ipVersionInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _sourceIpAddress?;
    /**
     * @stability stable
     */
    get sourceIpAddress(): string | undefined;
    /**
     * @stability stable
     */
    set sourceIpAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourceIpAddress(): void;
    /**
     * @stability stable
     */
    get sourceIpAddressInput(): string | undefined;
    private _sourcePort?;
    /**
     * @stability stable
     */
    get sourcePort(): string | undefined;
    /**
     * @stability stable
     */
    set sourcePort(value: string | undefined);
    /**
     * @stability stable
     */
    resetSourcePort(): void;
    /**
     * @stability stable
     */
    get sourcePortInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _valueSpecs?;
    /**
     * @stability stable
     */
    get valueSpecs(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set valueSpecs(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetValueSpecs(): void;
    /**
     * @stability stable
     */
    get valueSpecsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
