import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityAgencyV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#delegated_domain_name IdentityAgencyV3#delegated_domain_name}.
     *
     * @stability stable
     */
    readonly delegatedDomainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#description IdentityAgencyV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#domain_roles IdentityAgencyV3#domain_roles}.
     *
     * @stability stable
     */
    readonly domainRoles?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#name IdentityAgencyV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * project_role block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#project_role IdentityAgencyV3#project_role}
     *
     * @stability stable
     */
    readonly projectRole?: IdentityAgencyV3ProjectRole[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#timeouts IdentityAgencyV3#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityAgencyV3Timeouts;
}
/**
 * @stability stable
 */
export interface IdentityAgencyV3ProjectRole {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#project IdentityAgencyV3#project}.
     *
     * @stability stable
     */
    readonly project: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#roles IdentityAgencyV3#roles}.
     *
     * @stability stable
     */
    readonly roles: string[];
}
/**
 * @stability stable
 */
export interface IdentityAgencyV3Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#create IdentityAgencyV3#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#delete IdentityAgencyV3#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html#update IdentityAgencyV3#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class IdentityAgencyV3TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html opentelekomcloud_identity_agency_v3}.
 *
 * @stability stable
 */
export declare class IdentityAgencyV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_agency_v3.html opentelekomcloud_identity_agency_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityAgencyV3Config);
    /**
     * @stability stable
     */
    get createTime(): string;
    private _delegatedDomainName?;
    /**
     * @stability stable
     */
    get delegatedDomainName(): string;
    /**
     * @stability stable
     */
    set delegatedDomainName(value: string);
    /**
     * @stability stable
     */
    get delegatedDomainNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _domainRoles?;
    /**
     * @stability stable
     */
    get domainRoles(): string[] | undefined;
    /**
     * @stability stable
     */
    set domainRoles(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetDomainRoles(): void;
    /**
     * @stability stable
     */
    get domainRolesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _projectRole?;
    /**
     * @stability stable
     */
    get projectRole(): IdentityAgencyV3ProjectRole[] | undefined;
    /**
     * @stability stable
     */
    set projectRole(value: IdentityAgencyV3ProjectRole[] | undefined);
    /**
     * @stability stable
     */
    resetProjectRole(): void;
    /**
     * @stability stable
     */
    get projectRoleInput(): IdentityAgencyV3ProjectRole[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): IdentityAgencyV3TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IdentityAgencyV3Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityAgencyV3Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
