import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityCredentialV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_credential_v3.html#description IdentityCredentialV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_credential_v3.html#status IdentityCredentialV3#status}.
     *
     * @stability stable
     */
    readonly status?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_credential_v3.html#user_id IdentityCredentialV3#user_id}.
     *
     * @stability stable
     */
    readonly userId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_credential_v3.html opentelekomcloud_identity_credential_v3}.
 *
 * @stability stable
 */
export declare class IdentityCredentialV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_credential_v3.html opentelekomcloud_identity_credential_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: IdentityCredentialV3Config);
    /**
     * @stability stable
     */
    get access(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastUseTime(): string;
    /**
     * @stability stable
     */
    get secret(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string | undefined;
    /**
     * @stability stable
     */
    set userId(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
