import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityGroupMembershipV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_group_membership_v3.html#group IdentityGroupMembershipV3#group}.
     *
     * @stability stable
     */
    readonly group: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_group_membership_v3.html#users IdentityGroupMembershipV3#users}.
     *
     * @stability stable
     */
    readonly users: string[];
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_group_membership_v3.html opentelekomcloud_identity_group_membership_v3}.
 *
 * @stability stable
 */
export declare class IdentityGroupMembershipV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_group_membership_v3.html opentelekomcloud_identity_group_membership_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityGroupMembershipV3Config);
    private _group?;
    /**
     * @stability stable
     */
    get group(): string;
    /**
     * @stability stable
     */
    set group(value: string);
    /**
     * @stability stable
     */
    get groupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _users?;
    /**
     * @stability stable
     */
    get users(): string[];
    /**
     * @stability stable
     */
    set users(value: string[]);
    /**
     * @stability stable
     */
    get usersInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
