import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityMappingV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3.html#mapping_id IdentityMappingV3#mapping_id}.
     *
     * @stability stable
     */
    readonly mappingId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3.html#rules IdentityMappingV3#rules}.
     *
     * @stability stable
     */
    readonly rules: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3.html opentelekomcloud_identity_mapping_v3}.
 *
 * @stability stable
 */
export declare class IdentityMappingV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_mapping_v3.html opentelekomcloud_identity_mapping_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityMappingV3Config);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    links(key: string): string;
    private _mappingId?;
    /**
     * @stability stable
     */
    get mappingId(): string;
    /**
     * @stability stable
     */
    set mappingId(value: string);
    /**
     * @stability stable
     */
    get mappingIdInput(): string | undefined;
    private _rules?;
    /**
     * @stability stable
     */
    get rules(): string;
    /**
     * @stability stable
     */
    set rules(value: string);
    /**
     * @stability stable
     */
    get rulesInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
