import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityProjectV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html#description IdentityProjectV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html#domain_id IdentityProjectV3#domain_id}.
     *
     * @stability stable
     */
    readonly domainId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html#name IdentityProjectV3#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html#parent_id IdentityProjectV3#parent_id}.
     *
     * @stability stable
     */
    readonly parentId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html#region IdentityProjectV3#region}.
     *
     * @stability stable
     */
    readonly region?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html opentelekomcloud_identity_project_v3}.
 *
 * @stability stable
 */
export declare class IdentityProjectV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_project_v3.html opentelekomcloud_identity_project_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityProjectV3Config);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string | undefined;
    /**
     * @stability stable
     */
    set domainId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainId(): void;
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isDomain(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parentId?;
    /**
     * @stability stable
     */
    get parentId(): string | undefined;
    /**
     * @stability stable
     */
    set parentId(value: string | undefined);
    /**
     * @stability stable
     */
    resetParentId(): void;
    /**
     * @stability stable
     */
    get parentIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
