import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityProtocolV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#mapping_id IdentityProtocolV3#mapping_id}.
     *
     * @stability stable
     */
    readonly mappingId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#protocol IdentityProtocolV3#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#provider_id IdentityProtocolV3#provider_id}.
     *
     * @stability stable
     */
    readonly providerId: string;
    /**
     * metadata block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#metadata IdentityProtocolV3#metadata}
     *
     * @stability stable
     */
    readonly metadata?: IdentityProtocolV3Metadata;
}
/**
 * @stability stable
 */
export interface IdentityProtocolV3Metadata {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#domain_id IdentityProtocolV3#domain_id}.
     *
     * @stability stable
     */
    readonly domainId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#metadata IdentityProtocolV3#metadata}.
     *
     * @stability stable
     */
    readonly metadata: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html#xaccount_type IdentityProtocolV3#xaccount_type}.
     *
     * @stability stable
     */
    readonly xaccountType?: string;
}
/**
 * @stability stable
 */
export declare class IdentityProtocolV3MetadataOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    set domainId(value: string);
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): string;
    /**
     * @stability stable
     */
    set metadata(value: string);
    /**
     * @stability stable
     */
    get metadataInput(): string | undefined;
    private _xaccountType?;
    /**
     * @stability stable
     */
    get xaccountType(): string | undefined;
    /**
     * @stability stable
     */
    set xaccountType(value: string | undefined);
    /**
     * @stability stable
     */
    resetXaccountType(): void;
    /**
     * @stability stable
     */
    get xaccountTypeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html opentelekomcloud_identity_protocol_v3}.
 *
 * @stability stable
 */
export declare class IdentityProtocolV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_protocol_v3.html opentelekomcloud_identity_protocol_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityProtocolV3Config);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    links(key: string): string;
    private _mappingId?;
    /**
     * @stability stable
     */
    get mappingId(): string;
    /**
     * @stability stable
     */
    set mappingId(value: string);
    /**
     * @stability stable
     */
    get mappingIdInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _providerId?;
    /**
     * @stability stable
     */
    get providerId(): string;
    /**
     * @stability stable
     */
    set providerId(value: string);
    /**
     * @stability stable
     */
    get providerIdInput(): string | undefined;
    private _metadata?;
    private __metadataOutput;
    /**
     * @stability stable
     */
    get metadata(): IdentityProtocolV3MetadataOutputReference;
    /**
     * @stability stable
     */
    putMetadata(value: IdentityProtocolV3Metadata | undefined): void;
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): IdentityProtocolV3Metadata | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
