import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityRoleAssignmentV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html#domain_id IdentityRoleAssignmentV3#domain_id}.
     *
     * @stability stable
     */
    readonly domainId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html#group_id IdentityRoleAssignmentV3#group_id}.
     *
     * @stability stable
     */
    readonly groupId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html#project_id IdentityRoleAssignmentV3#project_id}.
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html#role_id IdentityRoleAssignmentV3#role_id}.
     *
     * @stability stable
     */
    readonly roleId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html#user_id IdentityRoleAssignmentV3#user_id}.
     *
     * @stability stable
     */
    readonly userId?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html opentelekomcloud_identity_role_assignment_v3}.
 *
 * @stability stable
 */
export declare class IdentityRoleAssignmentV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_assignment_v3.html opentelekomcloud_identity_role_assignment_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityRoleAssignmentV3Config);
    private _domainId?;
    /**
     * @stability stable
     */
    get domainId(): string | undefined;
    /**
     * @stability stable
     */
    set domainId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainId(): void;
    /**
     * @stability stable
     */
    get domainIdInput(): string | undefined;
    private _groupId?;
    /**
     * @stability stable
     */
    get groupId(): string | undefined;
    /**
     * @stability stable
     */
    set groupId(value: string | undefined);
    /**
     * @stability stable
     */
    resetGroupId(): void;
    /**
     * @stability stable
     */
    get groupIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _roleId?;
    /**
     * @stability stable
     */
    get roleId(): string;
    /**
     * @stability stable
     */
    set roleId(value: string);
    /**
     * @stability stable
     */
    get roleIdInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string | undefined;
    /**
     * @stability stable
     */
    set userId(value: string | undefined);
    /**
     * @stability stable
     */
    resetUserId(): void;
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
