import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityRoleV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#description IdentityRoleV3#description}.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#display_layer IdentityRoleV3#display_layer}.
     *
     * @stability stable
     */
    readonly displayLayer: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#display_name IdentityRoleV3#display_name}.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * statement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#statement IdentityRoleV3#statement}
     *
     * @stability stable
     */
    readonly statement: IdentityRoleV3Statement[];
}
/**
 * @stability stable
 */
export interface IdentityRoleV3Statement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#action IdentityRoleV3#action}.
     *
     * @stability stable
     */
    readonly action: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html#effect IdentityRoleV3#effect}.
     *
     * @stability stable
     */
    readonly effect: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html opentelekomcloud_identity_role_v3}.
 *
 * @stability stable
 */
export declare class IdentityRoleV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/identity_role_v3.html opentelekomcloud_identity_role_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityRoleV3Config);
    /**
     * @stability stable
     */
    get catalog(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayLayer?;
    /**
     * @stability stable
     */
    get displayLayer(): string;
    /**
     * @stability stable
     */
    set displayLayer(value: string);
    /**
     * @stability stable
     */
    get displayLayerInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _statement?;
    /**
     * @stability stable
     */
    get statement(): IdentityRoleV3Statement[];
    /**
     * @stability stable
     */
    set statement(value: IdentityRoleV3Statement[]);
    /**
     * @stability stable
     */
    get statementInput(): IdentityRoleV3Statement[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
