import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ImagesImageAccessV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_access_v2.html#image_id ImagesImageAccessV2#image_id}.
     *
     * @stability stable
     */
    readonly imageId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_access_v2.html#member_id ImagesImageAccessV2#member_id}.
     *
     * @stability stable
     */
    readonly memberId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_access_v2.html#status ImagesImageAccessV2#status}.
     *
     * @stability stable
     */
    readonly status?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_access_v2.html opentelekomcloud_images_image_access_v2}.
 *
 * @stability stable
 */
export declare class ImagesImageAccessV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_access_v2.html opentelekomcloud_images_image_access_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImagesImageAccessV2Config);
    /**
     * @stability stable
     */
    get createdAt(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageId?;
    /**
     * @stability stable
     */
    get imageId(): string;
    /**
     * @stability stable
     */
    set imageId(value: string);
    /**
     * @stability stable
     */
    get imageIdInput(): string | undefined;
    private _memberId?;
    /**
     * @stability stable
     */
    get memberId(): string;
    /**
     * @stability stable
     */
    set memberId(value: string);
    /**
     * @stability stable
     */
    get memberIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get schema(): string;
    private _status?;
    /**
     * @stability stable
     */
    get status(): string | undefined;
    /**
     * @stability stable
     */
    set status(value: string | undefined);
    /**
     * @stability stable
     */
    resetStatus(): void;
    /**
     * @stability stable
     */
    get statusInput(): string | undefined;
    /**
     * @stability stable
     */
    get updateAt(): string;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
