import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ImagesImageV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#container_format ImagesImageV2#container_format}.
     *
     * @stability stable
     */
    readonly containerFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#disk_format ImagesImageV2#disk_format}.
     *
     * @stability stable
     */
    readonly diskFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#image_cache_path ImagesImageV2#image_cache_path}.
     *
     * @stability stable
     */
    readonly imageCachePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#image_source_url ImagesImageV2#image_source_url}.
     *
     * @stability stable
     */
    readonly imageSourceUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#local_file_path ImagesImageV2#local_file_path}.
     *
     * @stability stable
     */
    readonly localFilePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#min_disk_gb ImagesImageV2#min_disk_gb}.
     *
     * @stability stable
     */
    readonly minDiskGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#min_ram_mb ImagesImageV2#min_ram_mb}.
     *
     * @stability stable
     */
    readonly minRamMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#name ImagesImageV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#protected ImagesImageV2#protected}.
     *
     * @stability stable
     */
    readonly protected?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#region ImagesImageV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#tags ImagesImageV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#visibility ImagesImageV2#visibility}.
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#timeouts ImagesImageV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ImagesImageV2Timeouts;
}
/**
 * @stability stable
 */
export interface ImagesImageV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html#create ImagesImageV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
}
/**
 * @stability stable
 */
export declare class ImagesImageV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html opentelekomcloud_images_image_v2}.
 *
 * @stability stable
 */
export declare class ImagesImageV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/images_image_v2.html opentelekomcloud_images_image_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImagesImageV2Config);
    /**
     * @stability stable
     */
    get checksum(): string;
    private _containerFormat?;
    /**
     * @stability stable
     */
    get containerFormat(): string;
    /**
     * @stability stable
     */
    set containerFormat(value: string);
    /**
     * @stability stable
     */
    get containerFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _diskFormat?;
    /**
     * @stability stable
     */
    get diskFormat(): string;
    /**
     * @stability stable
     */
    set diskFormat(value: string);
    /**
     * @stability stable
     */
    get diskFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageCachePath?;
    /**
     * @stability stable
     */
    get imageCachePath(): string | undefined;
    /**
     * @stability stable
     */
    set imageCachePath(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageCachePath(): void;
    /**
     * @stability stable
     */
    get imageCachePathInput(): string | undefined;
    private _imageSourceUrl?;
    /**
     * @stability stable
     */
    get imageSourceUrl(): string | undefined;
    /**
     * @stability stable
     */
    set imageSourceUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageSourceUrl(): void;
    /**
     * @stability stable
     */
    get imageSourceUrlInput(): string | undefined;
    private _localFilePath?;
    /**
     * @stability stable
     */
    get localFilePath(): string | undefined;
    /**
     * @stability stable
     */
    set localFilePath(value: string | undefined);
    /**
     * @stability stable
     */
    resetLocalFilePath(): void;
    /**
     * @stability stable
     */
    get localFilePathInput(): string | undefined;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _minDiskGb?;
    /**
     * @stability stable
     */
    get minDiskGb(): number | undefined;
    /**
     * @stability stable
     */
    set minDiskGb(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinDiskGb(): void;
    /**
     * @stability stable
     */
    get minDiskGbInput(): number | undefined;
    private _minRamMb?;
    /**
     * @stability stable
     */
    get minRamMb(): number | undefined;
    /**
     * @stability stable
     */
    set minRamMb(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinRamMb(): void;
    /**
     * @stability stable
     */
    get minRamMbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get owner(): string;
    private _protected?;
    /**
     * @stability stable
     */
    get protected(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set protected(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetProtected(): void;
    /**
     * @stability stable
     */
    get protectedInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    get sizeBytes(): number;
    /**
     * @stability stable
     */
    get status(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[] | undefined;
    /**
     * @stability stable
     */
    set tags(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get updateAt(): string;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string | undefined;
    /**
     * @stability stable
     */
    set visibility(value: string | undefined);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ImagesImageV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ImagesImageV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ImagesImageV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
