import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ImsDataImageV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#cmk_id ImsDataImageV2#cmk_id}.
     *
     * @stability stable
     */
    readonly cmkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#description ImsDataImageV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#image_url ImsDataImageV2#image_url}.
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#min_disk ImsDataImageV2#min_disk}.
     *
     * @stability stable
     */
    readonly minDisk?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#name ImsDataImageV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#os_type ImsDataImageV2#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#tags ImsDataImageV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#volume_id ImsDataImageV2#volume_id}.
     *
     * @stability stable
     */
    readonly volumeId?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#timeouts ImsDataImageV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ImsDataImageV2Timeouts;
}
/**
 * @stability stable
 */
export interface ImsDataImageV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#create ImsDataImageV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html#delete ImsDataImageV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ImsDataImageV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html opentelekomcloud_ims_data_image_v2}.
 *
 * @stability stable
 */
export declare class ImsDataImageV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_data_image_v2.html opentelekomcloud_ims_data_image_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImsDataImageV2Config);
    private _cmkId?;
    /**
     * @stability stable
     */
    get cmkId(): string | undefined;
    /**
     * @stability stable
     */
    set cmkId(value: string | undefined);
    /**
     * @stability stable
     */
    resetCmkId(): void;
    /**
     * @stability stable
     */
    get cmkIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get dataOrigin(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get diskFormat(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imageSize(): string;
    private _imageUrl?;
    /**
     * @stability stable
     */
    get imageUrl(): string | undefined;
    /**
     * @stability stable
     */
    set imageUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageUrl(): void;
    /**
     * @stability stable
     */
    get imageUrlInput(): string | undefined;
    private _minDisk?;
    /**
     * @stability stable
     */
    get minDisk(): number | undefined;
    /**
     * @stability stable
     */
    set minDisk(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinDisk(): void;
    /**
     * @stability stable
     */
    get minDiskInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string | undefined;
    /**
     * @stability stable
     */
    set osType(value: string | undefined);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get visibility(): string;
    private _volumeId?;
    /**
     * @stability stable
     */
    get volumeId(): string | undefined;
    /**
     * @stability stable
     */
    set volumeId(value: string | undefined);
    /**
     * @stability stable
     */
    resetVolumeId(): void;
    /**
     * @stability stable
     */
    get volumeIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ImsDataImageV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ImsDataImageV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ImsDataImageV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
