import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ImsImageV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#cmk_id ImsImageV2#cmk_id}.
     *
     * @stability stable
     */
    readonly cmkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#description ImsImageV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#image_url ImsImageV2#image_url}.
     *
     * @stability stable
     */
    readonly imageUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#instance_id ImsImageV2#instance_id}.
     *
     * @stability stable
     */
    readonly instanceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#is_config ImsImageV2#is_config}.
     *
     * @stability stable
     */
    readonly isConfig?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#max_ram ImsImageV2#max_ram}.
     *
     * @stability stable
     */
    readonly maxRam?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#min_disk ImsImageV2#min_disk}.
     *
     * @stability stable
     */
    readonly minDisk?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#min_ram ImsImageV2#min_ram}.
     *
     * @stability stable
     */
    readonly minRam?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#name ImsImageV2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#os_version ImsImageV2#os_version}.
     *
     * @stability stable
     */
    readonly osVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#tags ImsImageV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#type ImsImageV2#type}.
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#timeouts ImsImageV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ImsImageV2Timeouts;
}
/**
 * @stability stable
 */
export interface ImsImageV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#create ImsImageV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html#delete ImsImageV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ImsImageV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html opentelekomcloud_ims_image_v2}.
 *
 * @stability stable
 */
export declare class ImsImageV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/ims_image_v2.html opentelekomcloud_ims_image_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImsImageV2Config);
    private _cmkId?;
    /**
     * @stability stable
     */
    get cmkId(): string | undefined;
    /**
     * @stability stable
     */
    set cmkId(value: string | undefined);
    /**
     * @stability stable
     */
    resetCmkId(): void;
    /**
     * @stability stable
     */
    get cmkIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get dataOrigin(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get diskFormat(): string;
    /**
     * @stability stable
     */
    get file(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get imageSize(): string;
    private _imageUrl?;
    /**
     * @stability stable
     */
    get imageUrl(): string | undefined;
    /**
     * @stability stable
     */
    set imageUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetImageUrl(): void;
    /**
     * @stability stable
     */
    get imageUrlInput(): string | undefined;
    private _instanceId?;
    /**
     * @stability stable
     */
    get instanceId(): string | undefined;
    /**
     * @stability stable
     */
    set instanceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetInstanceId(): void;
    /**
     * @stability stable
     */
    get instanceIdInput(): string | undefined;
    private _isConfig?;
    /**
     * @stability stable
     */
    get isConfig(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isConfig(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsConfig(): void;
    /**
     * @stability stable
     */
    get isConfigInput(): boolean | cdktf.IResolvable | undefined;
    private _maxRam?;
    /**
     * @stability stable
     */
    get maxRam(): number | undefined;
    /**
     * @stability stable
     */
    set maxRam(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRam(): void;
    /**
     * @stability stable
     */
    get maxRamInput(): number | undefined;
    private _minDisk?;
    /**
     * @stability stable
     */
    get minDisk(): number | undefined;
    /**
     * @stability stable
     */
    set minDisk(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinDisk(): void;
    /**
     * @stability stable
     */
    get minDiskInput(): number | undefined;
    private _minRam?;
    /**
     * @stability stable
     */
    get minRam(): number | undefined;
    /**
     * @stability stable
     */
    set minRam(value: number | undefined);
    /**
     * @stability stable
     */
    resetMinRam(): void;
    /**
     * @stability stable
     */
    get minRamInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _osVersion?;
    /**
     * @stability stable
     */
    get osVersion(): string | undefined;
    /**
     * @stability stable
     */
    set osVersion(value: string | undefined);
    /**
     * @stability stable
     */
    resetOsVersion(): void;
    /**
     * @stability stable
     */
    get osVersionInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string | undefined;
    /**
     * @stability stable
     */
    set type(value: string | undefined);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get visibility(): string;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ImsImageV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ImsImageV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ImsImageV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
