import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsGrantV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html#grantee_principal KmsGrantV1#grantee_principal}.
     *
     * @stability stable
     */
    readonly granteePrincipal: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html#key_id KmsGrantV1#key_id}.
     *
     * @stability stable
     */
    readonly keyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html#name KmsGrantV1#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html#operations KmsGrantV1#operations}.
     *
     * @stability stable
     */
    readonly operations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html#retiring_principal KmsGrantV1#retiring_principal}.
     *
     * @stability stable
     */
    readonly retiringPrincipal?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html opentelekomcloud_kms_grant_v1}.
 *
 * @stability stable
 */
export declare class KmsGrantV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_grant_v1.html opentelekomcloud_kms_grant_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsGrantV1Config);
    /**
     * @stability stable
     */
    get creationDate(): string;
    private _granteePrincipal?;
    /**
     * @stability stable
     */
    get granteePrincipal(): string;
    /**
     * @stability stable
     */
    set granteePrincipal(value: string);
    /**
     * @stability stable
     */
    get granteePrincipalInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get issuingPrincipal(): string;
    private _keyId?;
    /**
     * @stability stable
     */
    get keyId(): string;
    /**
     * @stability stable
     */
    set keyId(value: string);
    /**
     * @stability stable
     */
    get keyIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): string[] | undefined;
    /**
     * @stability stable
     */
    set operations(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): string[] | undefined;
    private _retiringPrincipal?;
    /**
     * @stability stable
     */
    get retiringPrincipal(): string | undefined;
    /**
     * @stability stable
     */
    set retiringPrincipal(value: string | undefined);
    /**
     * @stability stable
     */
    resetRetiringPrincipal(): void;
    /**
     * @stability stable
     */
    get retiringPrincipalInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
