import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsKeyV1Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#is_enabled KmsKeyV1#is_enabled}.
     *
     * @stability stable
     */
    readonly isEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#key_alias KmsKeyV1#key_alias}.
     *
     * @stability stable
     */
    readonly keyAlias: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#key_description KmsKeyV1#key_description}.
     *
     * @stability stable
     */
    readonly keyDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#pending_days KmsKeyV1#pending_days}.
     *
     * @stability stable
     */
    readonly pendingDays?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#realm KmsKeyV1#realm}.
     *
     * @stability stable
     */
    readonly realm?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html#tags KmsKeyV1#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html opentelekomcloud_kms_key_v1}.
 *
 * @stability stable
 */
export declare class KmsKeyV1 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/kms_key_v1.html opentelekomcloud_kms_key_v1} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsKeyV1Config);
    /**
     * @stability stable
     */
    get creationDate(): string;
    /**
     * @stability stable
     */
    get defaultKeyFlag(): string;
    /**
     * @stability stable
     */
    get domainId(): string;
    /**
     * @stability stable
     */
    get expirationTime(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _isEnabled?;
    /**
     * @stability stable
     */
    get isEnabled(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set isEnabled(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIsEnabled(): void;
    /**
     * @stability stable
     */
    get isEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAlias?;
    /**
     * @stability stable
     */
    get keyAlias(): string;
    /**
     * @stability stable
     */
    set keyAlias(value: string);
    /**
     * @stability stable
     */
    get keyAliasInput(): string | undefined;
    private _keyDescription?;
    /**
     * @stability stable
     */
    get keyDescription(): string | undefined;
    /**
     * @stability stable
     */
    set keyDescription(value: string | undefined);
    /**
     * @stability stable
     */
    resetKeyDescription(): void;
    /**
     * @stability stable
     */
    get keyDescriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get origin(): string;
    private _pendingDays?;
    /**
     * @stability stable
     */
    get pendingDays(): string | undefined;
    /**
     * @stability stable
     */
    set pendingDays(value: string | undefined);
    /**
     * @stability stable
     */
    resetPendingDays(): void;
    /**
     * @stability stable
     */
    get pendingDaysInput(): string | undefined;
    private _realm?;
    /**
     * @stability stable
     */
    get realm(): string | undefined;
    /**
     * @stability stable
     */
    set realm(value: string | undefined);
    /**
     * @stability stable
     */
    resetRealm(): void;
    /**
     * @stability stable
     */
    get realmInput(): string | undefined;
    /**
     * @stability stable
     */
    get scheduledDeletionDate(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
