import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbL7RuleV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#admin_state_up LbL7RuleV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#compare_type LbL7RuleV2#compare_type}.
     *
     * @stability stable
     */
    readonly compareType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#key LbL7RuleV2#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#l7policy_id LbL7RuleV2#l7policy_id}.
     *
     * @stability stable
     */
    readonly l7PolicyId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#region LbL7RuleV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#tenant_id LbL7RuleV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#type LbL7RuleV2#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#value LbL7RuleV2#value}.
     *
     * @stability stable
     */
    readonly value: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#timeouts LbL7RuleV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbL7RuleV2Timeouts;
}
/**
 * @stability stable
 */
export interface LbL7RuleV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#create LbL7RuleV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#delete LbL7RuleV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html#update LbL7RuleV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class LbL7RuleV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html opentelekomcloud_lb_l7rule_v2}.
 *
 * @stability stable
 */
export declare class LbL7RuleV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_l7rule_v2.html opentelekomcloud_lb_l7rule_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbL7RuleV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _compareType?;
    /**
     * @stability stable
     */
    get compareType(): string;
    /**
     * @stability stable
     */
    set compareType(value: string);
    /**
     * @stability stable
     */
    get compareTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _key?;
    /**
     * @stability stable
     */
    get key(): string | undefined;
    /**
     * @stability stable
     */
    set key(value: string | undefined);
    /**
     * @stability stable
     */
    resetKey(): void;
    /**
     * @stability stable
     */
    get keyInput(): string | undefined;
    private _l7PolicyId?;
    /**
     * @stability stable
     */
    get l7PolicyId(): string;
    /**
     * @stability stable
     */
    set l7PolicyId(value: string);
    /**
     * @stability stable
     */
    get l7PolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get listenerId(): string;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _value?;
    /**
     * @stability stable
     */
    get value(): string;
    /**
     * @stability stable
     */
    set value(value: string);
    /**
     * @stability stable
     */
    get valueInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): LbL7RuleV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbL7RuleV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbL7RuleV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
