import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbListenerV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#admin_state_up LbListenerV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#client_ca_tls_container_ref LbListenerV2#client_ca_tls_container_ref}.
     *
     * @stability stable
     */
    readonly clientCaTlsContainerRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#default_pool_id LbListenerV2#default_pool_id}.
     *
     * @stability stable
     */
    readonly defaultPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#default_tls_container_ref LbListenerV2#default_tls_container_ref}.
     *
     * @stability stable
     */
    readonly defaultTlsContainerRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#description LbListenerV2#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#http2_enable LbListenerV2#http2_enable}.
     *
     * @stability stable
     */
    readonly http2Enable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#loadbalancer_id LbListenerV2#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#name LbListenerV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#protocol LbListenerV2#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#protocol_port LbListenerV2#protocol_port}.
     *
     * @stability stable
     */
    readonly protocolPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#region LbListenerV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#sni_container_refs LbListenerV2#sni_container_refs}.
     *
     * @stability stable
     */
    readonly sniContainerRefs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#tags LbListenerV2#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#tenant_id LbListenerV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#tls_ciphers_policy LbListenerV2#tls_ciphers_policy}.
     *
     * @stability stable
     */
    readonly tlsCiphersPolicy?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#timeouts LbListenerV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbListenerV2Timeouts;
}
/**
 * @stability stable
 */
export interface LbListenerV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#create LbListenerV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#delete LbListenerV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html#update LbListenerV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class LbListenerV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html opentelekomcloud_lb_listener_v2}.
 *
 * @stability stable
 */
export declare class LbListenerV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v2.html opentelekomcloud_lb_listener_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbListenerV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCaTlsContainerRef?;
    /**
     * @stability stable
     */
    get clientCaTlsContainerRef(): string | undefined;
    /**
     * @stability stable
     */
    set clientCaTlsContainerRef(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCaTlsContainerRef(): void;
    /**
     * @stability stable
     */
    get clientCaTlsContainerRefInput(): string | undefined;
    private _defaultPoolId?;
    /**
     * @stability stable
     */
    get defaultPoolId(): string | undefined;
    /**
     * @stability stable
     */
    set defaultPoolId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultPoolId(): void;
    /**
     * @stability stable
     */
    get defaultPoolIdInput(): string | undefined;
    private _defaultTlsContainerRef?;
    /**
     * @stability stable
     */
    get defaultTlsContainerRef(): string | undefined;
    /**
     * @stability stable
     */
    set defaultTlsContainerRef(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultTlsContainerRef(): void;
    /**
     * @stability stable
     */
    get defaultTlsContainerRefInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _http2Enable?;
    /**
     * @stability stable
     */
    get http2Enable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set http2Enable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHttp2Enable(): void;
    /**
     * @stability stable
     */
    get http2EnableInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _protocolPort?;
    /**
     * @stability stable
     */
    get protocolPort(): number;
    /**
     * @stability stable
     */
    set protocolPort(value: number);
    /**
     * @stability stable
     */
    get protocolPortInput(): number | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _sniContainerRefs?;
    /**
     * @stability stable
     */
    get sniContainerRefs(): string[] | undefined;
    /**
     * @stability stable
     */
    set sniContainerRefs(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSniContainerRefs(): void;
    /**
     * @stability stable
     */
    get sniContainerRefsInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _tlsCiphersPolicy?;
    /**
     * @stability stable
     */
    get tlsCiphersPolicy(): string | undefined;
    /**
     * @stability stable
     */
    set tlsCiphersPolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetTlsCiphersPolicy(): void;
    /**
     * @stability stable
     */
    get tlsCiphersPolicyInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): LbListenerV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbListenerV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbListenerV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
