import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbListenerV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#admin_state_up LbListenerV3#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#client_ca_tls_container_ref LbListenerV3#client_ca_tls_container_ref}.
     *
     * @stability stable
     */
    readonly clientCaTlsContainerRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#client_timeout LbListenerV3#client_timeout}.
     *
     * @stability stable
     */
    readonly clientTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#default_pool_id LbListenerV3#default_pool_id}.
     *
     * @stability stable
     */
    readonly defaultPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#default_tls_container_ref LbListenerV3#default_tls_container_ref}.
     *
     * @stability stable
     */
    readonly defaultTlsContainerRef?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#description LbListenerV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#http2_enable LbListenerV3#http2_enable}.
     *
     * @stability stable
     */
    readonly http2Enable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#keep_alive_timeout LbListenerV3#keep_alive_timeout}.
     *
     * @stability stable
     */
    readonly keepAliveTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#loadbalancer_id LbListenerV3#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#member_retry_enable LbListenerV3#member_retry_enable}.
     *
     * @stability stable
     */
    readonly memberRetryEnable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#member_timeout LbListenerV3#member_timeout}.
     *
     * @stability stable
     */
    readonly memberTimeout?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#name LbListenerV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#protocol LbListenerV3#protocol}.
     *
     * @stability stable
     */
    readonly protocol: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#protocol_port LbListenerV3#protocol_port}.
     *
     * @stability stable
     */
    readonly protocolPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#sni_container_refs LbListenerV3#sni_container_refs}.
     *
     * @stability stable
     */
    readonly sniContainerRefs?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#tags LbListenerV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#tls_ciphers_policy LbListenerV3#tls_ciphers_policy}.
     *
     * @stability stable
     */
    readonly tlsCiphersPolicy?: string;
    /**
     * insert_headers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#insert_headers LbListenerV3#insert_headers}
     *
     * @stability stable
     */
    readonly insertHeaders?: LbListenerV3InsertHeaders;
}
/**
 * @stability stable
 */
export interface LbListenerV3InsertHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#forward_elb_ip LbListenerV3#forward_elb_ip}.
     *
     * @stability stable
     */
    readonly forwardElbIp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#forwarded_for_port LbListenerV3#forwarded_for_port}.
     *
     * @stability stable
     */
    readonly forwardedForPort?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#forwarded_host LbListenerV3#forwarded_host}.
     *
     * @stability stable
     */
    readonly forwardedHost?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html#forwarded_port LbListenerV3#forwarded_port}.
     *
     * @stability stable
     */
    readonly forwardedPort?: boolean | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class LbListenerV3InsertHeadersOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _forwardElbIp?;
    /**
     * @stability stable
     */
    get forwardElbIp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forwardElbIp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForwardElbIp(): void;
    /**
     * @stability stable
     */
    get forwardElbIpInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedForPort?;
    /**
     * @stability stable
     */
    get forwardedForPort(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forwardedForPort(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForwardedForPort(): void;
    /**
     * @stability stable
     */
    get forwardedForPortInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedHost?;
    /**
     * @stability stable
     */
    get forwardedHost(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forwardedHost(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForwardedHost(): void;
    /**
     * @stability stable
     */
    get forwardedHostInput(): boolean | cdktf.IResolvable | undefined;
    private _forwardedPort?;
    /**
     * @stability stable
     */
    get forwardedPort(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forwardedPort(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForwardedPort(): void;
    /**
     * @stability stable
     */
    get forwardedPortInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html opentelekomcloud_lb_listener_v3}.
 *
 * @stability stable
 */
export declare class LbListenerV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_listener_v3.html opentelekomcloud_lb_listener_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbListenerV3Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCaTlsContainerRef?;
    /**
     * @stability stable
     */
    get clientCaTlsContainerRef(): string | undefined;
    /**
     * @stability stable
     */
    set clientCaTlsContainerRef(value: string | undefined);
    /**
     * @stability stable
     */
    resetClientCaTlsContainerRef(): void;
    /**
     * @stability stable
     */
    get clientCaTlsContainerRefInput(): string | undefined;
    private _clientTimeout?;
    /**
     * @stability stable
     */
    get clientTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set clientTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetClientTimeout(): void;
    /**
     * @stability stable
     */
    get clientTimeoutInput(): number | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _defaultPoolId?;
    /**
     * @stability stable
     */
    get defaultPoolId(): string | undefined;
    /**
     * @stability stable
     */
    set defaultPoolId(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultPoolId(): void;
    /**
     * @stability stable
     */
    get defaultPoolIdInput(): string | undefined;
    private _defaultTlsContainerRef?;
    /**
     * @stability stable
     */
    get defaultTlsContainerRef(): string | undefined;
    /**
     * @stability stable
     */
    set defaultTlsContainerRef(value: string | undefined);
    /**
     * @stability stable
     */
    resetDefaultTlsContainerRef(): void;
    /**
     * @stability stable
     */
    get defaultTlsContainerRefInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _http2Enable?;
    /**
     * @stability stable
     */
    get http2Enable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set http2Enable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetHttp2Enable(): void;
    /**
     * @stability stable
     */
    get http2EnableInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keepAliveTimeout?;
    /**
     * @stability stable
     */
    get keepAliveTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set keepAliveTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetKeepAliveTimeout(): void;
    /**
     * @stability stable
     */
    get keepAliveTimeoutInput(): number | undefined;
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _memberRetryEnable?;
    /**
     * @stability stable
     */
    get memberRetryEnable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set memberRetryEnable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetMemberRetryEnable(): void;
    /**
     * @stability stable
     */
    get memberRetryEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _memberTimeout?;
    /**
     * @stability stable
     */
    get memberTimeout(): number | undefined;
    /**
     * @stability stable
     */
    set memberTimeout(value: number | undefined);
    /**
     * @stability stable
     */
    resetMemberTimeout(): void;
    /**
     * @stability stable
     */
    get memberTimeoutInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _protocol?;
    /**
     * @stability stable
     */
    get protocol(): string;
    /**
     * @stability stable
     */
    set protocol(value: string);
    /**
     * @stability stable
     */
    get protocolInput(): string | undefined;
    private _protocolPort?;
    /**
     * @stability stable
     */
    get protocolPort(): number;
    /**
     * @stability stable
     */
    set protocolPort(value: number);
    /**
     * @stability stable
     */
    get protocolPortInput(): number | undefined;
    private _sniContainerRefs?;
    /**
     * @stability stable
     */
    get sniContainerRefs(): string[] | undefined;
    /**
     * @stability stable
     */
    set sniContainerRefs(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSniContainerRefs(): void;
    /**
     * @stability stable
     */
    get sniContainerRefsInput(): string[] | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tlsCiphersPolicy?;
    /**
     * @stability stable
     */
    get tlsCiphersPolicy(): string | undefined;
    /**
     * @stability stable
     */
    set tlsCiphersPolicy(value: string | undefined);
    /**
     * @stability stable
     */
    resetTlsCiphersPolicy(): void;
    /**
     * @stability stable
     */
    get tlsCiphersPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _insertHeaders?;
    private __insertHeadersOutput;
    /**
     * @stability stable
     */
    get insertHeaders(): LbListenerV3InsertHeadersOutputReference;
    /**
     * @stability stable
     */
    putInsertHeaders(value: LbListenerV3InsertHeaders | undefined): void;
    /**
     * @stability stable
     */
    resetInsertHeaders(): void;
    /**
     * @stability stable
     */
    get insertHeadersInput(): LbListenerV3InsertHeaders | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
