import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbLoadbalancerV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#admin_state_up LbLoadbalancerV3#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#availability_zones LbLoadbalancerV3#availability_zones}.
     *
     * @stability stable
     */
    readonly availabilityZones: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#description LbLoadbalancerV3#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#ip_target_enable LbLoadbalancerV3#ip_target_enable}.
     *
     * @stability stable
     */
    readonly ipTargetEnable?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#l4_flavor LbLoadbalancerV3#l4_flavor}.
     *
     * @stability stable
     */
    readonly l4Flavor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#l7_flavor LbLoadbalancerV3#l7_flavor}.
     *
     * @stability stable
     */
    readonly l7Flavor?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#name LbLoadbalancerV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#network_ids LbLoadbalancerV3#network_ids}.
     *
     * @stability stable
     */
    readonly networkIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#router_id LbLoadbalancerV3#router_id}.
     *
     * @stability stable
     */
    readonly routerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#subnet_id LbLoadbalancerV3#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#tags LbLoadbalancerV3#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#vip_address LbLoadbalancerV3#vip_address}.
     *
     * @stability stable
     */
    readonly vipAddress?: string;
    /**
     * public_ip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#public_ip LbLoadbalancerV3#public_ip}
     *
     * @stability stable
     */
    readonly publicIp?: LbLoadbalancerV3PublicIp;
}
/**
 * @stability stable
 */
export interface LbLoadbalancerV3PublicIp {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#bandwidth_charge_mode LbLoadbalancerV3#bandwidth_charge_mode}.
     *
     * @stability stable
     */
    readonly bandwidthChargeMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#bandwidth_name LbLoadbalancerV3#bandwidth_name}.
     *
     * @stability stable
     */
    readonly bandwidthName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#bandwidth_share_type LbLoadbalancerV3#bandwidth_share_type}.
     *
     * @stability stable
     */
    readonly bandwidthShareType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#bandwidth_size LbLoadbalancerV3#bandwidth_size}.
     *
     * @stability stable
     */
    readonly bandwidthSize: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html#ip_type LbLoadbalancerV3#ip_type}.
     *
     * @stability stable
     */
    readonly ipType: string;
}
/**
 * @stability stable
 */
export declare class LbLoadbalancerV3PublicIpOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _bandwidthChargeMode?;
    /**
     * @stability stable
     */
    get bandwidthChargeMode(): string | undefined;
    /**
     * @stability stable
     */
    set bandwidthChargeMode(value: string | undefined);
    /**
     * @stability stable
     */
    resetBandwidthChargeMode(): void;
    /**
     * @stability stable
     */
    get bandwidthChargeModeInput(): string | undefined;
    private _bandwidthName?;
    /**
     * @stability stable
     */
    get bandwidthName(): string;
    /**
     * @stability stable
     */
    set bandwidthName(value: string);
    /**
     * @stability stable
     */
    get bandwidthNameInput(): string | undefined;
    private _bandwidthShareType?;
    /**
     * @stability stable
     */
    get bandwidthShareType(): string;
    /**
     * @stability stable
     */
    set bandwidthShareType(value: string);
    /**
     * @stability stable
     */
    get bandwidthShareTypeInput(): string | undefined;
    private _bandwidthSize?;
    /**
     * @stability stable
     */
    get bandwidthSize(): number;
    /**
     * @stability stable
     */
    set bandwidthSize(value: number);
    /**
     * @stability stable
     */
    get bandwidthSizeInput(): number | undefined;
    private _ipType?;
    /**
     * @stability stable
     */
    get ipType(): string;
    /**
     * @stability stable
     */
    set ipType(value: string);
    /**
     * @stability stable
     */
    get ipTypeInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html opentelekomcloud_lb_loadbalancer_v3}.
 *
 * @stability stable
 */
export declare class LbLoadbalancerV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_loadbalancer_v3.html opentelekomcloud_lb_loadbalancer_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbLoadbalancerV3Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _availabilityZones?;
    /**
     * @stability stable
     */
    get availabilityZones(): string[];
    /**
     * @stability stable
     */
    set availabilityZones(value: string[]);
    /**
     * @stability stable
     */
    get availabilityZonesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get createdAt(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipTargetEnable?;
    /**
     * @stability stable
     */
    get ipTargetEnable(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set ipTargetEnable(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetIpTargetEnable(): void;
    /**
     * @stability stable
     */
    get ipTargetEnableInput(): boolean | cdktf.IResolvable | undefined;
    private _l4Flavor?;
    /**
     * @stability stable
     */
    get l4Flavor(): string | undefined;
    /**
     * @stability stable
     */
    set l4Flavor(value: string | undefined);
    /**
     * @stability stable
     */
    resetL4Flavor(): void;
    /**
     * @stability stable
     */
    get l4FlavorInput(): string | undefined;
    private _l7Flavor?;
    /**
     * @stability stable
     */
    get l7Flavor(): string | undefined;
    /**
     * @stability stable
     */
    set l7Flavor(value: string | undefined);
    /**
     * @stability stable
     */
    resetL7Flavor(): void;
    /**
     * @stability stable
     */
    get l7FlavorInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkIds?;
    /**
     * @stability stable
     */
    get networkIds(): string[];
    /**
     * @stability stable
     */
    set networkIds(value: string[]);
    /**
     * @stability stable
     */
    get networkIdsInput(): string[] | undefined;
    private _routerId?;
    /**
     * @stability stable
     */
    get routerId(): string | undefined;
    /**
     * @stability stable
     */
    set routerId(value: string | undefined);
    /**
     * @stability stable
     */
    resetRouterId(): void;
    /**
     * @stability stable
     */
    get routerIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string | undefined;
    /**
     * @stability stable
     */
    set subnetId(value: string | undefined);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get updatedAt(): string;
    private _vipAddress?;
    /**
     * @stability stable
     */
    get vipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set vipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetVipAddress(): void;
    /**
     * @stability stable
     */
    get vipAddressInput(): string | undefined;
    /**
     * @stability stable
     */
    get vipPortId(): string;
    private _publicIp?;
    private __publicIpOutput;
    /**
     * @stability stable
     */
    get publicIp(): LbLoadbalancerV3PublicIpOutputReference;
    /**
     * @stability stable
     */
    putPublicIp(value: LbLoadbalancerV3PublicIp | undefined): void;
    /**
     * @stability stable
     */
    resetPublicIp(): void;
    /**
     * @stability stable
     */
    get publicIpInput(): LbLoadbalancerV3PublicIp | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
