import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbMemberV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#address LbMemberV2#address}.
     *
     * @stability stable
     */
    readonly address: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#admin_state_up LbMemberV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#name LbMemberV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#pool_id LbMemberV2#pool_id}.
     *
     * @stability stable
     */
    readonly poolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#protocol_port LbMemberV2#protocol_port}.
     *
     * @stability stable
     */
    readonly protocolPort: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#region LbMemberV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#subnet_id LbMemberV2#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#tenant_id LbMemberV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#weight LbMemberV2#weight}.
     *
     * @stability stable
     */
    readonly weight?: number;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#timeouts LbMemberV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbMemberV2Timeouts;
}
/**
 * @stability stable
 */
export interface LbMemberV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#create LbMemberV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#delete LbMemberV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html#update LbMemberV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class LbMemberV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html opentelekomcloud_lb_member_v2}.
 *
 * @stability stable
 */
export declare class LbMemberV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_member_v2.html opentelekomcloud_lb_member_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbMemberV2Config);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolId?;
    /**
     * @stability stable
     */
    get poolId(): string;
    /**
     * @stability stable
     */
    set poolId(value: string);
    /**
     * @stability stable
     */
    get poolIdInput(): string | undefined;
    private _protocolPort?;
    /**
     * @stability stable
     */
    get protocolPort(): number;
    /**
     * @stability stable
     */
    set protocolPort(value: number);
    /**
     * @stability stable
     */
    get protocolPortInput(): number | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number | undefined;
    /**
     * @stability stable
     */
    set weight(value: number | undefined);
    /**
     * @stability stable
     */
    resetWeight(): void;
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): LbMemberV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbMemberV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbMemberV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
