import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbMonitorV2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#admin_state_up LbMonitorV2#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#delay LbMonitorV2#delay}.
     *
     * @stability stable
     */
    readonly delay: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#domain_name LbMonitorV2#domain_name}.
     *
     * @stability stable
     */
    readonly domainName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#expected_codes LbMonitorV2#expected_codes}.
     *
     * @stability stable
     */
    readonly expectedCodes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#http_method LbMonitorV2#http_method}.
     *
     * @stability stable
     */
    readonly httpMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#max_retries LbMonitorV2#max_retries}.
     *
     * @stability stable
     */
    readonly maxRetries: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#monitor_port LbMonitorV2#monitor_port}.
     *
     * @stability stable
     */
    readonly monitorPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#name LbMonitorV2#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#pool_id LbMonitorV2#pool_id}.
     *
     * @stability stable
     */
    readonly poolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#region LbMonitorV2#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#tenant_id LbMonitorV2#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#timeout LbMonitorV2#timeout}.
     *
     * @stability stable
     */
    readonly timeout: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#type LbMonitorV2#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#url_path LbMonitorV2#url_path}.
     *
     * @stability stable
     */
    readonly urlPath?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#timeouts LbMonitorV2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: LbMonitorV2Timeouts;
}
/**
 * @stability stable
 */
export interface LbMonitorV2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#create LbMonitorV2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#delete LbMonitorV2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html#update LbMonitorV2#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class LbMonitorV2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html opentelekomcloud_lb_monitor_v2}.
 *
 * @stability stable
 */
export declare class LbMonitorV2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v2.html opentelekomcloud_lb_monitor_v2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbMonitorV2Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _delay?;
    /**
     * @stability stable
     */
    get delay(): number;
    /**
     * @stability stable
     */
    set delay(value: number);
    /**
     * @stability stable
     */
    get delayInput(): number | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string | undefined;
    /**
     * @stability stable
     */
    set domainName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainName(): void;
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _expectedCodes?;
    /**
     * @stability stable
     */
    get expectedCodes(): string | undefined;
    /**
     * @stability stable
     */
    set expectedCodes(value: string | undefined);
    /**
     * @stability stable
     */
    resetExpectedCodes(): void;
    /**
     * @stability stable
     */
    get expectedCodesInput(): string | undefined;
    private _httpMethod?;
    /**
     * @stability stable
     */
    get httpMethod(): string | undefined;
    /**
     * @stability stable
     */
    set httpMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetHttpMethod(): void;
    /**
     * @stability stable
     */
    get httpMethodInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number;
    /**
     * @stability stable
     */
    set maxRetries(value: number);
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
    private _monitorPort?;
    /**
     * @stability stable
     */
    get monitorPort(): number | undefined;
    /**
     * @stability stable
     */
    set monitorPort(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonitorPort(): void;
    /**
     * @stability stable
     */
    get monitorPortInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolId?;
    /**
     * @stability stable
     */
    get poolId(): string;
    /**
     * @stability stable
     */
    set poolId(value: string);
    /**
     * @stability stable
     */
    get poolIdInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string | undefined;
    /**
     * @stability stable
     */
    set tenantId(value: string | undefined);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _urlPath?;
    /**
     * @stability stable
     */
    get urlPath(): string | undefined;
    /**
     * @stability stable
     */
    set urlPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrlPath(): void;
    /**
     * @stability stable
     */
    get urlPathInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): LbMonitorV2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: LbMonitorV2Timeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): LbMonitorV2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
