import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LbMonitorV3Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#admin_state_up LbMonitorV3#admin_state_up}.
     *
     * @stability stable
     */
    readonly adminStateUp?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#delay LbMonitorV3#delay}.
     *
     * @stability stable
     */
    readonly delay: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#domain_name LbMonitorV3#domain_name}.
     *
     * @stability stable
     */
    readonly domainName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#expected_codes LbMonitorV3#expected_codes}.
     *
     * @stability stable
     */
    readonly expectedCodes?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#http_method LbMonitorV3#http_method}.
     *
     * @stability stable
     */
    readonly httpMethod?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#max_retries LbMonitorV3#max_retries}.
     *
     * @stability stable
     */
    readonly maxRetries: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#max_retries_down LbMonitorV3#max_retries_down}.
     *
     * @stability stable
     */
    readonly maxRetriesDown?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#monitor_port LbMonitorV3#monitor_port}.
     *
     * @stability stable
     */
    readonly monitorPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#name LbMonitorV3#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#pool_id LbMonitorV3#pool_id}.
     *
     * @stability stable
     */
    readonly poolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#project_id LbMonitorV3#project_id}.
     *
     * @stability stable
     */
    readonly projectId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#timeout LbMonitorV3#timeout}.
     *
     * @stability stable
     */
    readonly timeout: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#type LbMonitorV3#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html#url_path LbMonitorV3#url_path}.
     *
     * @stability stable
     */
    readonly urlPath?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html opentelekomcloud_lb_monitor_v3}.
 *
 * @stability stable
 */
export declare class LbMonitorV3 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/opentelekomcloud/r/lb_monitor_v3.html opentelekomcloud_lb_monitor_v3} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LbMonitorV3Config);
    private _adminStateUp?;
    /**
     * @stability stable
     */
    get adminStateUp(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set adminStateUp(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetAdminStateUp(): void;
    /**
     * @stability stable
     */
    get adminStateUpInput(): boolean | cdktf.IResolvable | undefined;
    private _delay?;
    /**
     * @stability stable
     */
    get delay(): number;
    /**
     * @stability stable
     */
    set delay(value: number);
    /**
     * @stability stable
     */
    get delayInput(): number | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string | undefined;
    /**
     * @stability stable
     */
    set domainName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDomainName(): void;
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _expectedCodes?;
    /**
     * @stability stable
     */
    get expectedCodes(): string | undefined;
    /**
     * @stability stable
     */
    set expectedCodes(value: string | undefined);
    /**
     * @stability stable
     */
    resetExpectedCodes(): void;
    /**
     * @stability stable
     */
    get expectedCodesInput(): string | undefined;
    private _httpMethod?;
    /**
     * @stability stable
     */
    get httpMethod(): string | undefined;
    /**
     * @stability stable
     */
    set httpMethod(value: string | undefined);
    /**
     * @stability stable
     */
    resetHttpMethod(): void;
    /**
     * @stability stable
     */
    get httpMethodInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _maxRetries?;
    /**
     * @stability stable
     */
    get maxRetries(): number;
    /**
     * @stability stable
     */
    set maxRetries(value: number);
    /**
     * @stability stable
     */
    get maxRetriesInput(): number | undefined;
    private _maxRetriesDown?;
    /**
     * @stability stable
     */
    get maxRetriesDown(): number | undefined;
    /**
     * @stability stable
     */
    set maxRetriesDown(value: number | undefined);
    /**
     * @stability stable
     */
    resetMaxRetriesDown(): void;
    /**
     * @stability stable
     */
    get maxRetriesDownInput(): number | undefined;
    private _monitorPort?;
    /**
     * @stability stable
     */
    get monitorPort(): number | undefined;
    /**
     * @stability stable
     */
    set monitorPort(value: number | undefined);
    /**
     * @stability stable
     */
    resetMonitorPort(): void;
    /**
     * @stability stable
     */
    get monitorPortInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string | undefined;
    /**
     * @stability stable
     */
    set name(value: string | undefined);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolId?;
    /**
     * @stability stable
     */
    get poolId(): string;
    /**
     * @stability stable
     */
    set poolId(value: string);
    /**
     * @stability stable
     */
    get poolIdInput(): string | undefined;
    private _projectId?;
    /**
     * @stability stable
     */
    get projectId(): string | undefined;
    /**
     * @stability stable
     */
    set projectId(value: string | undefined);
    /**
     * @stability stable
     */
    resetProjectId(): void;
    /**
     * @stability stable
     */
    get projectIdInput(): string | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): number;
    /**
     * @stability stable
     */
    set timeout(value: number);
    /**
     * @stability stable
     */
    get timeoutInput(): number | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _urlPath?;
    /**
     * @stability stable
     */
    get urlPath(): string | undefined;
    /**
     * @stability stable
     */
    set urlPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetUrlPath(): void;
    /**
     * @stability stable
     */
    get urlPathInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
